/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.osgi.framework.Version;

public class BundleInfo
implements Serializable {
    private static final long serialVersionUID = -2363297020450715134L;
    private URL rootURL;
    private String location;
    private String symbolicName;
    private String version;
    private transient VirtualFile rootFile;
    private transient Manifest manifest;

    public static BundleInfo createBundleInfo(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        URL url = BundleInfo.getRealLocation(location);
        if (url == null) {
            throw new IllegalArgumentException("Cannot obtain root url from: " + location);
        }
        return new BundleInfo(BundleInfo.toVirtualFile(url), location);
    }

    public static BundleInfo createBundleInfo(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null root url");
        }
        return new BundleInfo(BundleInfo.toVirtualFile(url), url.toExternalForm());
    }

    public static BundleInfo createBundleInfo(VirtualFile root) {
        return new BundleInfo(root, null);
    }

    public static BundleInfo createBundleInfo(VirtualFile root, String location) {
        return new BundleInfo(root, location);
    }

    private BundleInfo(VirtualFile rootFile, String location) {
        if (rootFile == null) {
            throw new IllegalArgumentException("Root file cannot be null");
        }
        this.rootFile = rootFile;
        this.rootURL = BundleInfo.toURL(rootFile);
        if (location == null) {
            location = this.rootURL.toExternalForm();
        }
        this.location = location;
        this.symbolicName = this.getManifestHeader("Bundle-SymbolicName");
        if (this.symbolicName == null) {
            throw new IllegalArgumentException("Cannot obtain Bundle-SymbolicName for: " + rootFile);
        }
        this.version = this.getManifestHeader("Bundle-Version");
        this.version = Version.parseVersion((String)this.version).toString();
    }

    public String getManifestHeader(String key) {
        Attributes attribs = this.getManifest().getMainAttributes();
        String value = attribs.getValue(key);
        return value;
    }

    public String getLocation() {
        return this.location;
    }

    public VirtualFile getRoot() {
        if (this.rootFile == null) {
            this.rootFile = BundleInfo.toVirtualFile(this.rootURL);
        }
        return this.rootFile;
    }

    public URL getRootURL() {
        return BundleInfo.toURL(this.getRoot());
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return Version.parseVersion((String)this.version);
    }

    private Manifest getManifest() {
        if (this.manifest == null) {
            try {
                this.manifest = VFSUtils.getManifest((VirtualFile)this.getRoot());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot get manifest from: " + this.rootURL, ex);
            }
        }
        return this.manifest;
    }

    private static URL getRealLocation(String location) {
        String prefix;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (url == null) {
            try {
                File file = new File(location);
                if (file.exists()) {
                    url = file.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (url == null && new File(prefix = System.getProperty("test.archive.directory", "target/test-libs")).exists()) {
            return BundleInfo.getRealLocation(prefix + File.separator + location);
        }
        return url;
    }

    private static VirtualFile toVirtualFile(URL url) {
        try {
            return VFS.getRoot((URL)url);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid root url: " + url, e);
        }
    }

    private static URL toURL(VirtualFile file) {
        try {
            return file.toURL();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid root file: " + file);
        }
    }

    private String toEqualString() {
        return "[" + this.symbolicName + "-" + this.version + ",url=" + this.rootURL + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BundleInfo)) {
            return false;
        }
        BundleInfo other = (BundleInfo)obj;
        return this.toEqualString().equals(other.toEqualString());
    }

    public int hashCode() {
        return this.toEqualString().hashCode();
    }

    public String toString() {
        return this.toEqualString();
    }
}

