/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceLoader {
    static final Logger log = LoggerFactory.getLogger(ServiceLoader.class);

    public static <T> List<T> loadServices(Class<T> serviceClass) {
        String filename;
        ArrayList services = new ArrayList();
        ClassLoader loader = serviceClass.getClassLoader();
        InputStream inStream = loader.getResourceAsStream(filename = "META-INF/services/" + serviceClass.getName());
        if (inStream == null) {
            log.debug("Cannot find resource: " + filename);
        }
        if (inStream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                String implClassName = br.readLine();
                while (implClassName != null) {
                    int hashIndex = implClassName.indexOf("#");
                    if (hashIndex > 0) {
                        implClassName = implClassName.substring(0, hashIndex);
                    }
                    if ((implClassName = implClassName.trim()).length() > 0) {
                        try {
                            Class<?> implClass = loader.loadClass(implClassName);
                            if (serviceClass.isAssignableFrom(implClass)) {
                                services.add(implClass.newInstance());
                            } else {
                                log.warn("Not assignable: " + implClassName);
                            }
                        }
                        catch (Exception ex) {
                            log.debug("Cannot load service: " + implClassName);
                        }
                    }
                    implClassName = br.readLine();
                }
                br.close();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to load services for: " + serviceClass.getName());
            }
        }
        return services;
    }

    public static <T> T loadService(Class<T> serviceClass) {
        List<T> services = ServiceLoader.loadServices(serviceClass);
        if (services.isEmpty()) {
            return null;
        }
        return services.get(0);
    }
}

