/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.osgi.metadata.DynamicOSGiMetaData;
import org.jboss.osgi.metadata.OSGiManifestMetaData;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.internal.MetadataMessages;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class OSGiMetaDataBuilder {
    private DynamicOSGiMetaData metadata;
    private List<String> importPackages = new ArrayList<String>();
    private List<String> exportPackages = new ArrayList<String>();
    private List<String> dynamicImportPackages = new ArrayList<String>();

    public static OSGiMetaData load(InputStream input) throws IOException {
        if (input == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("input");
        }
        return OSGiMetaDataBuilder.load(new InputStreamReader(input));
    }

    public static OSGiMetaData load(Reader reader) throws IOException {
        if (reader == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("reader");
        }
        Properties props = new Properties();
        props.load(reader);
        return OSGiMetaDataBuilder.load(props);
    }

    public static OSGiMetaData load(Properties props) {
        if (props == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("props");
        }
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        for (Object key : props.keySet()) {
            Attributes.Name name = new Attributes.Name((String)key);
            mainAttributes.put(name, props.get(key));
        }
        return OSGiMetaDataBuilder.load(manifest);
    }

    public static OSGiMetaData load(Manifest manifest) {
        if (manifest == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("manifest");
        }
        return new OSGiManifestMetaData(manifest);
    }

    public static boolean isValidMetadata(OSGiMetaData metadata) {
        if (metadata == null) {
            return false;
        }
        try {
            OSGiMetaDataBuilder.validateMetadata(metadata);
            return true;
        }
        catch (BundleException e) {
            return false;
        }
    }

    public static void validateMetadata(OSGiMetaData metadata) throws BundleException {
        if (metadata == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("metadata");
        }
        int manifestVersion = OSGiMetaDataBuilder.getBundleManifestVersion(metadata);
        if (manifestVersion < 0) {
            throw MetadataMessages.MESSAGES.bundleCannotObtainBundleManifestVersion();
        }
        if (manifestVersion > 2) {
            throw MetadataMessages.MESSAGES.bundleUnsupportedBundleManifestVersion(manifestVersion);
        }
        String symbolicName = metadata.getBundleSymbolicName();
        if (manifestVersion == 1 && symbolicName != null) {
            throw MetadataMessages.MESSAGES.bundleInvalidBundleManifestVersion(symbolicName);
        }
        if (manifestVersion == 2 && symbolicName == null) {
            throw MetadataMessages.MESSAGES.bundleCannotObtainBundleSymbolicName();
        }
    }

    private static int getBundleManifestVersion(OSGiMetaData metaData) {
        String bundleName = metaData.getBundleName();
        String bundleSymbolicName = metaData.getBundleSymbolicName();
        Version bundleVersion = metaData.getBundleVersion();
        if (bundleName == null && bundleSymbolicName == null && bundleVersion.equals((Object)Version.emptyVersion)) {
            return -1;
        }
        Integer manifestVersion = metaData.getBundleManifestVersion();
        return manifestVersion != null ? manifestVersion : 1;
    }

    public static OSGiMetaDataBuilder createBuilder(String symbolicName) {
        if (symbolicName == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("symbolicName");
        }
        return new OSGiMetaDataBuilder(symbolicName, Version.emptyVersion);
    }

    public static OSGiMetaDataBuilder createBuilder(String symbolicName, Version version) {
        if (symbolicName == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("symbolicName");
        }
        if (version == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("version");
        }
        return new OSGiMetaDataBuilder(symbolicName, version);
    }

    private OSGiMetaDataBuilder(String symbolicName, Version version) {
        this.metadata = new DynamicOSGiMetaData(symbolicName, version);
    }

    public OSGiMetaDataBuilder setBundleManifestVersion(int version) {
        this.metadata.addMainAttribute("Bundle-ManifestVersion", "" + version);
        return this;
    }

    public OSGiMetaDataBuilder setBundleActivator(String value) {
        this.metadata.addMainAttribute("Bundle-Activator", value);
        return this;
    }

    public OSGiMetaDataBuilder addImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addImportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addImportPackages(String ... packages) {
        for (String aux : packages) {
            this.importPackages.add(aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addExportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addExportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addExportPackages(String ... packages) {
        for (String aux : packages) {
            this.exportPackages.add(aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addDynamicImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addDynamicImportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addDynamicImportPackages(String ... packages) {
        for (String aux : packages) {
            this.dynamicImportPackages.add(aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addMainAttribute(String key, String value) {
        this.metadata.addMainAttribute(key, value);
        return this;
    }

    public OSGiMetaData getAndValidateMetaData() throws BundleException {
        OSGiMetaData metadata = this.getMetaDataInternal();
        OSGiMetaDataBuilder.validateMetadata(metadata);
        return metadata;
    }

    private OSGiMetaData getMetaDataInternal() {
        int i;
        StringBuffer value;
        if (this.exportPackages.size() > 0) {
            value = new StringBuffer();
            for (i = 0; i < this.exportPackages.size(); ++i) {
                value.append(i > 0 ? "," : "");
                value.append(this.exportPackages.get(i));
            }
            this.metadata.addMainAttribute("Export-Package", value.toString());
        }
        if (this.importPackages.size() > 0) {
            value = new StringBuffer();
            for (i = 0; i < this.importPackages.size(); ++i) {
                value.append(i > 0 ? "," : "");
                value.append(this.importPackages.get(i));
            }
            this.metadata.addMainAttribute("Import-Package", value.toString());
        }
        if (this.dynamicImportPackages.size() > 0) {
            value = new StringBuffer();
            for (i = 0; i < this.dynamicImportPackages.size(); ++i) {
                value.append(i > 0 ? "," : "");
                value.append(this.dynamicImportPackages.get(i));
            }
            this.metadata.addMainAttribute("DynamicImport-Package", value.toString());
        }
        return this.metadata;
    }

    public OSGiMetaData getOSGiMetaData() {
        return this.getMetaDataInternal();
    }
}

