/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

abstract class AbstractTracked {
    static final boolean DEBUG = false;
    private final Map tracked = new HashMap();
    private int trackingCount = 0;
    private final List adding = new ArrayList(6);
    volatile boolean closed = false;
    private final LinkedList initial = new LinkedList();

    AbstractTracked() {
    }

    void setInitial(Object[] list) {
        if (list == null) {
            return;
        }
        for (Object item : list) {
            if (item == null) continue;
            this.initial.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackInitial() {
        while (true) {
            Object item;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.closed || this.initial.size() == 0) {
                    return;
                }
                item = this.initial.removeFirst();
                if (this.tracked.get(item) != null) {
                    continue;
                }
                if (this.adding.contains(item)) {
                    continue;
                }
                this.adding.add(item);
            }
            this.trackAdding(item, null);
        }
    }

    void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void track(Object item, Object related) {
        Object object;
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.closed) {
                return;
            }
            object = this.tracked.get(item);
            if (object == null) {
                if (this.adding.contains(item)) {
                    return;
                }
                this.adding.add(item);
            } else {
                this.modified();
            }
        }
        if (object == null) {
            this.trackAdding(item, related);
        } else {
            this.customizerModified(item, related, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackAdding(Object item, Object related) {
        Object object = null;
        boolean becameUntracked = false;
        try {
            object = this.customizerAdding(item, related);
        }
        finally {
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.adding.remove(item) && !this.closed) {
                    if (object != null) {
                        this.tracked.put(item, object);
                        this.modified();
                        this.notifyAll();
                    }
                } else {
                    becameUntracked = true;
                }
            }
        }
        if (becameUntracked && object != null) {
            this.customizerRemoved(item, related, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void untrack(Object item, Object related) {
        Object object;
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.initial.remove(item)) {
                return;
            }
            if (this.adding.remove(item)) {
                return;
            }
            object = this.tracked.remove(item);
            if (object == null) {
                return;
            }
            this.modified();
        }
        this.customizerRemoved(item, related, object);
    }

    int size() {
        return this.tracked.size();
    }

    Object getCustomizedObject(Object item) {
        return this.tracked.get(item);
    }

    Object[] getTracked(Object[] list) {
        return this.tracked.keySet().toArray(list);
    }

    void modified() {
        ++this.trackingCount;
    }

    int getTrackingCount() {
        return this.trackingCount;
    }

    abstract Object customizerAdding(Object var1, Object var2);

    abstract void customizerModified(Object var1, Object var2, Object var3);

    abstract void customizerRemoved(Object var1, Object var2, Object var3);
}

