/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.util.VersionRange;

public class RequirementImpl
implements Requirement {
    private final Module m_module;
    private final String m_namespace;
    private final SimpleFilter m_filter;
    private final boolean m_optional;
    private final List<Directive> m_dirs;
    private final List<Directive> m_dirsConst;

    public RequirementImpl(Module module, String namespace, List<Directive> dirs, List<Attribute> attrs) {
        this.m_module = module;
        this.m_namespace = namespace;
        this.m_dirs = dirs;
        this.m_dirsConst = Collections.unmodifiableList(this.m_dirs);
        this.m_filter = RequirementImpl.convertToFilter(attrs);
        boolean optional = false;
        for (int dirIdx = 0; dirIdx < this.m_dirs.size(); ++dirIdx) {
            if (!this.m_dirs.get(dirIdx).getName().equals("resolution")) continue;
            optional = this.m_dirs.get(dirIdx).getValue().equals("optional");
        }
        this.m_optional = optional;
    }

    @Override
    public Module getModule() {
        return this.m_module;
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public SimpleFilter getFilter() {
        return this.m_filter;
    }

    @Override
    public boolean isOptional() {
        return this.m_optional;
    }

    @Override
    public Directive getDirective(String name) {
        for (int i = 0; i < this.m_dirs.size(); ++i) {
            if (!this.m_dirs.get(i).getName().equals(name)) continue;
            return this.m_dirs.get(i);
        }
        return null;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.m_dirsConst;
    }

    public String toString() {
        return "[" + this.m_module + "] " + this.m_namespace + "; " + this.getFilter().toString();
    }

    private static SimpleFilter convertToFilter(List<Attribute> attrs) {
        ArrayList<SimpleFilter> filters = new ArrayList<SimpleFilter>();
        for (Attribute attr : attrs) {
            if (attr.getValue() instanceof VersionRange) {
                SimpleFilter not;
                VersionRange vr = (VersionRange)attr.getValue();
                if (vr.isFloorInclusive()) {
                    filters.add(new SimpleFilter(attr.getName(), vr.getFloor().toString(), 6));
                } else {
                    not = new SimpleFilter(null, new ArrayList(), 3);
                    ((List)not.getValue()).add(new SimpleFilter(attr.getName(), vr.getFloor().toString(), 5));
                    filters.add(not);
                }
                if (vr.getCeiling() == null) continue;
                if (vr.isCeilingInclusive()) {
                    filters.add(new SimpleFilter(attr.getName(), vr.getCeiling().toString(), 5));
                    continue;
                }
                not = new SimpleFilter(null, new ArrayList(), 3);
                ((List)not.getValue()).add(new SimpleFilter(attr.getName(), vr.getCeiling().toString(), 6));
                filters.add(not);
                continue;
            }
            List<String> values = SimpleFilter.parseSubstring(attr.getValue().toString());
            if (values.size() > 1) {
                filters.add(new SimpleFilter(attr.getName(), values, 7));
                continue;
            }
            filters.add(new SimpleFilter(attr.getName(), values.get(0), 4));
        }
        SimpleFilter sf = null;
        if (filters.size() == 1) {
            sf = (SimpleFilter)filters.get(0);
        } else if (attrs.size() > 1) {
            sf = new SimpleFilter(null, filters, 1);
        }
        return sf;
    }
}

