/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.resolver.Candidates;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.Util;
import org.apache.felix.resolver.WireImpl;
import org.apache.felix.resolver.WrappedCapability;
import org.apache.felix.resolver.WrappedRequirement;
import org.apache.felix.resolver.WrappedResource;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;
import org.osgi.service.resolver.Resolver;

public class ResolverImpl
implements Resolver {
    private final Logger m_logger;
    private final List<Candidates> m_usesPermutations = new ArrayList<Candidates>();
    private final List<Candidates> m_importPermutations = new ArrayList<Candidates>();
    private Map<Capability, List<Capability>> m_packageSourcesCache = new HashMap<Capability, List<Capability>>();

    public ResolverImpl(Logger logger) {
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Resource, List<Wire>> resolve(ResolveContext rc) throws ResolutionException {
        boolean retry;
        Map<Resource, List<Wire>> wireMap = new HashMap<Resource, List<Wire>>();
        HashMap<Resource, Packages> resourcePkgMap = new HashMap<Resource, Packages>();
        ArrayList mandatoryResources = new ArrayList(rc.getMandatoryResources());
        ArrayList optionalResources = new ArrayList(rc.getOptionalResources());
        List ondemandFragments = Collections.EMPTY_LIST;
        do {
            retry = false;
            try {
                List hostReq;
                Resource target;
                Iterator i$;
                Resource resource4;
                boolean isFragment;
                Candidates allCandidates = new Candidates();
                Iterator it = mandatoryResources.iterator();
                while (it.hasNext()) {
                    Resource resource2 = (Resource)it.next();
                    if (Util.isFragment(resource2) || rc.getWirings().get(resource2) == null) {
                        allCandidates.populate(rc, resource2, 0);
                        continue;
                    }
                    it.remove();
                }
                for (Resource resource2 : optionalResources) {
                    isFragment = Util.isFragment(resource2);
                    if (!isFragment && rc.getWirings().get(resource2) != null) continue;
                    allCandidates.populate(rc, resource2, 1);
                }
                for (Resource resource2 : ondemandFragments) {
                    isFragment = Util.isFragment(resource2);
                    if (!isFragment) continue;
                    allCandidates.populate(rc, resource2, 2);
                }
                allCandidates.prepare(rc);
                HashSet<Resource> allResources = new HashSet<Resource>(mandatoryResources);
                for (Resource resource3 : optionalResources) {
                    if (!allCandidates.isPopulated(resource3)) continue;
                    allResources.add(resource3);
                }
                this.m_usesPermutations.add(allCandidates);
                ResolutionException rethrow = null;
                HashMap<Resource, List> hostReqs = new HashMap<Resource, List>();
                for (Resource resource4 : allResources) {
                    if (!Util.isFragment(resource4)) continue;
                    hostReqs.put(resource4, resource4.getRequirements("osgi.wiring.host"));
                }
                do {
                    rethrow = null;
                    resourcePkgMap.clear();
                    this.m_packageSourcesCache.clear();
                    allCandidates = this.m_usesPermutations.size() > 0 ? this.m_usesPermutations.remove(0) : this.m_importPermutations.remove(0);
                    i$ = allResources.iterator();
                    while (i$.hasNext()) {
                        target = resource4 = (Resource)i$.next();
                        hostReq = (List)hostReqs.get(resource4);
                        if (hostReq != null) {
                            target = allCandidates.getCandidates((Requirement)hostReq.get(0)).iterator().next().getResource();
                        }
                        this.calculatePackageSpaces(rc, allCandidates.getWrappedHost(target), allCandidates, resourcePkgMap, new HashMap<Capability, List<Resource>>(), new HashSet<Resource>());
                        try {
                            this.checkPackageSpaceConsistency(rc, false, allCandidates.getWrappedHost(target), allCandidates, resourcePkgMap, new HashMap<Resource, Object>());
                        }
                        catch (ResolutionException ex) {
                            rethrow = ex;
                        }
                    }
                } while (rethrow != null && (this.m_usesPermutations.size() > 0 || this.m_importPermutations.size() > 0));
                if (rethrow != null) {
                    Resource faultyResource;
                    Collection exReqs = rethrow.getUnresolvedRequirements();
                    Requirement faultyReq = exReqs == null || exReqs.isEmpty() ? null : (Requirement)exReqs.iterator().next();
                    Resource resource5 = faultyResource = faultyReq == null ? null : ResolverImpl.getDeclaredResource(faultyReq.getResource());
                    if (faultyReq instanceof WrappedRequirement) {
                        faultyResource = ((WrappedRequirement)faultyReq).getDeclaredRequirement().getResource();
                    }
                    if (optionalResources.remove(faultyResource)) {
                        retry = true;
                        continue;
                    }
                    if (ondemandFragments.remove(faultyResource)) {
                        retry = true;
                        continue;
                    }
                    throw rethrow;
                }
                i$ = allResources.iterator();
                while (i$.hasNext()) {
                    target = resource4 = (Resource)i$.next();
                    hostReq = (List)hostReqs.get(resource4);
                    if (hostReq != null) {
                        target = allCandidates.getCandidates((Requirement)hostReq.get(0)).iterator().next().getResource();
                    }
                    if (!allCandidates.isPopulated(target)) continue;
                    wireMap = ResolverImpl.populateWireMap(rc, allCandidates.getWrappedHost(target), resourcePkgMap, wireMap, allCandidates);
                }
            }
            finally {
                this.m_usesPermutations.clear();
                this.m_importPermutations.clear();
            }
        } while (retry);
        return wireMap;
    }

    private void calculatePackageSpaces(ResolveContext rc, Resource resource, Candidates allCandidates, Map<Resource, Packages> resourcePkgMap, Map<Capability, List<Resource>> usesCycleMap, Set<Resource> cycle) {
        Capability cap;
        int i;
        Requirement req2;
        if (cycle.contains(resource)) {
            return;
        }
        cycle.add(resource);
        Packages resourcePkgs = resourcePkgMap.get(resource);
        if (resourcePkgs != null) {
            if (resourcePkgs.m_isCalculated) {
                return;
            }
            resourcePkgs.m_isCalculated = true;
        }
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        ArrayList<Capability> caps = new ArrayList<Capability>();
        boolean isDynamicImporting = false;
        Wiring wiring = (Wiring)rc.getWirings().get(resource);
        if (wiring != null) {
            for (Wire wire : wiring.getRequiredResourceWires(null)) {
                Object c;
                Requirement r = wire.getRequirement();
                if (!r.getResource().equals(wire.getRequirer()) || r.getDirectives().get("resolution") != null && ((String)r.getDirectives().get("resolution")).equals("dynamic")) {
                    r = new WrappedRequirement(wire.getRequirer(), r);
                }
                if (!(c = wire.getCapability()).getResource().equals(wire.getProvider())) {
                    c = new WrappedCapability(wire.getProvider(), (Capability)c);
                }
                reqs.add(r);
                caps.add((Capability)c);
            }
            for (Requirement req2 : Util.getDynamicRequirements(wiring.getResourceRequirements(null))) {
                List<Capability> candCaps = allCandidates.getCandidates(req2);
                if (candCaps == null) continue;
                Capability cap2 = candCaps.get(0);
                reqs.add(req2);
                caps.add(cap2);
                isDynamicImporting = true;
                break;
            }
        } else {
            for (Requirement req2 : resource.getRequirements(null)) {
                List<Capability> candCaps;
                String resolution = (String)req2.getDirectives().get("resolution");
                if (resolution != null && resolution.equals("dynamic") || (candCaps = allCandidates.getCandidates(req2)) == null) continue;
                Capability cap3 = candCaps.get(0);
                reqs.add(req2);
                caps.add(cap3);
            }
        }
        ResolverImpl.calculateExportedPackages(rc, resource, allCandidates, resourcePkgMap);
        resourcePkgs = resourcePkgMap.get(resource);
        for (i = 0; i < reqs.size(); ++i) {
            req2 = (Requirement)reqs.get(i);
            cap = (Capability)caps.get(i);
            ResolverImpl.calculateExportedPackages(rc, cap.getResource(), allCandidates, resourcePkgMap);
            this.mergeCandidatePackages(rc, resource, req2, cap, resourcePkgMap, allCandidates, new HashMap<Resource, List<Capability>>());
        }
        for (i = 0; i < caps.size(); ++i) {
            this.calculatePackageSpaces(rc, ((Capability)caps.get(i)).getResource(), allCandidates, resourcePkgMap, usesCycleMap, cycle);
        }
        if (wiring == null || isDynamicImporting) {
            ArrayList<Requirement> blameReqs;
            for (i = 0; i < reqs.size(); ++i) {
                req2 = (Requirement)reqs.get(i);
                cap = (Capability)caps.get(i);
                if (req2.getNamespace().equals("osgi.wiring.bundle") || req2.getNamespace().equals("osgi.wiring.package")) continue;
                ArrayList<Requirement> blameReqs2 = new ArrayList<Requirement>();
                blameReqs2.add(req2);
                this.mergeUses(rc, resource, resourcePkgs, cap, blameReqs2, resourcePkgMap, allCandidates, usesCycleMap);
            }
            for (Map.Entry<String, List<Blame>> entry : resourcePkgs.m_importedPkgs.entrySet()) {
                for (Blame blame : entry.getValue()) {
                    if (blame.m_cap.getResource().equals(resource)) continue;
                    blameReqs = new ArrayList<Requirement>();
                    blameReqs.add(blame.m_reqs.get(0));
                    this.mergeUses(rc, resource, resourcePkgs, blame.m_cap, blameReqs, resourcePkgMap, allCandidates, usesCycleMap);
                }
            }
            for (Map.Entry<String, List<Blame>> entry : resourcePkgs.m_requiredPkgs.entrySet()) {
                for (Blame blame : entry.getValue()) {
                    blameReqs = new ArrayList();
                    blameReqs.add(blame.m_reqs.get(0));
                    this.mergeUses(rc, resource, resourcePkgs, blame.m_cap, blameReqs, resourcePkgMap, allCandidates, usesCycleMap);
                }
            }
        }
    }

    private void mergeCandidatePackages(ResolveContext rc, Resource current, Requirement currentReq, Capability candCap, Map<Resource, Packages> resourcePkgMap, Candidates allCandidates, Map<Resource, List<Capability>> cycles) {
        List<Capability> cycleCaps = cycles.get(current);
        if (cycleCaps == null) {
            cycleCaps = new ArrayList<Capability>();
            cycles.put(current, cycleCaps);
        }
        if (cycleCaps.contains(candCap)) {
            return;
        }
        cycleCaps.add(candCap);
        if (candCap.getNamespace().equals("osgi.wiring.package")) {
            this.mergeCandidatePackage(current, false, currentReq, candCap, resourcePkgMap);
        } else if (candCap.getNamespace().equals("osgi.wiring.bundle")) {
            ResolverImpl.calculateExportedPackages(rc, candCap.getResource(), allCandidates, resourcePkgMap);
            Packages candPkgs = resourcePkgMap.get(candCap.getResource());
            for (Map.Entry<String, Blame> entry : candPkgs.m_exportedPkgs.entrySet()) {
                this.mergeCandidatePackage(current, true, currentReq, entry.getValue().m_cap, resourcePkgMap);
            }
            Wiring candWiring = (Wiring)rc.getWirings().get(candCap.getResource());
            if (candWiring != null) {
                for (Wire w : candWiring.getRequiredResourceWires(null)) {
                    String value;
                    if (!w.getRequirement().getNamespace().equals("osgi.wiring.bundle") || (value = (String)w.getRequirement().getDirectives().get("visibility")) == null || !value.equals("reexport")) continue;
                    this.mergeCandidatePackages(rc, current, currentReq, w.getCapability(), resourcePkgMap, allCandidates, cycles);
                }
            } else {
                for (Requirement req : candCap.getResource().getRequirements(null)) {
                    String value;
                    if (!req.getNamespace().equals("osgi.wiring.bundle") || (value = (String)req.getDirectives().get("visibility")) == null || !value.equals("reexport") || allCandidates.getCandidates(req) == null) continue;
                    this.mergeCandidatePackages(rc, current, currentReq, allCandidates.getCandidates(req).iterator().next(), resourcePkgMap, allCandidates, cycles);
                }
            }
        }
        cycles.remove(current);
    }

    private void mergeCandidatePackage(Resource current, boolean requires, Requirement currentReq, Capability candCap, Map<Resource, Packages> resourcePkgMap) {
        if (candCap.getNamespace().equals("osgi.wiring.package")) {
            String pkgName = (String)candCap.getAttributes().get("osgi.wiring.package");
            ArrayList<Requirement> blameReqs = new ArrayList<Requirement>();
            blameReqs.add(currentReq);
            Packages currentPkgs = resourcePkgMap.get(current);
            Map<String, List<Blame>> packages = requires ? currentPkgs.m_requiredPkgs : currentPkgs.m_importedPkgs;
            List<Blame> blames = packages.get(pkgName);
            if (blames == null) {
                blames = new ArrayList<Blame>();
                packages.put(pkgName, blames);
            }
            blames.add(new Blame(candCap, blameReqs));
        }
    }

    private void mergeUses(ResolveContext rc, Resource current, Packages currentPkgs, Capability mergeCap, List<Requirement> blameReqs, Map<Resource, Packages> resourcePkgMap, Candidates allCandidates, Map<Capability, List<Resource>> cycleMap) {
        if (current.equals(mergeCap.getResource())) {
            return;
        }
        ArrayList<Resource> list = cycleMap.get(mergeCap);
        if (list != null && list.contains(current)) {
            return;
        }
        list = list == null ? new ArrayList<Resource>() : list;
        list.add(current);
        cycleMap.put(mergeCap, list);
        for (Capability candSourceCap : this.getPackageSources(rc, mergeCap, resourcePkgMap)) {
            ArrayList<String> uses = Collections.EMPTY_LIST;
            String s = (String)candSourceCap.getDirectives().get("uses");
            if (s != null) {
                StringTokenizer tok = new StringTokenizer(s, ",");
                uses = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreTokens()) {
                    uses.add(tok.nextToken().trim());
                }
            }
            for (String usedPkgName : uses) {
                List<Object> candSourceBlames;
                Packages candSourcePkgs = resourcePkgMap.get(candSourceCap.getResource());
                Blame candExportedBlame = candSourcePkgs.m_exportedPkgs.get(usedPkgName);
                if (candExportedBlame != null) {
                    candSourceBlames = new ArrayList<Blame>(1);
                    candSourceBlames.add(candExportedBlame);
                } else {
                    candSourceBlames = candSourcePkgs.m_requiredPkgs.get(usedPkgName);
                    List<Object> list2 = candSourceBlames = candSourceBlames != null ? candSourceBlames : candSourcePkgs.m_importedPkgs.get(usedPkgName);
                }
                if (candSourceBlames == null) continue;
                List<Blame> usedCaps = currentPkgs.m_usedPkgs.get(usedPkgName);
                if (usedCaps == null) {
                    usedCaps = new ArrayList<Blame>();
                    currentPkgs.m_usedPkgs.put(usedPkgName, usedCaps);
                }
                for (Blame blame : candSourceBlames) {
                    if (blame.m_reqs != null) {
                        ArrayList<Requirement> blameReqs2 = new ArrayList<Requirement>(blameReqs);
                        blameReqs2.add(blame.m_reqs.get(blame.m_reqs.size() - 1));
                        usedCaps.add(new Blame(blame.m_cap, blameReqs2));
                        this.mergeUses(rc, current, currentPkgs, blame.m_cap, blameReqs2, resourcePkgMap, allCandidates, cycleMap);
                        continue;
                    }
                    usedCaps.add(new Blame(blame.m_cap, blameReqs));
                    this.mergeUses(rc, current, currentPkgs, blame.m_cap, blameReqs, resourcePkgMap, allCandidates, cycleMap);
                }
            }
        }
    }

    private void checkPackageSpaceConsistency(ResolveContext rc, boolean isDynamicImporting, Resource resource, Candidates allCandidates, Map<Resource, Packages> resourcePkgMap, Map<Resource, Object> resultCache) throws ResolutionException {
        if (rc.getWirings().containsKey(resource) && !isDynamicImporting) {
            return;
        }
        if (resultCache.containsKey(resource)) {
            return;
        }
        Packages pkgs = resourcePkgMap.get(resource);
        ResolutionException rethrow = null;
        Candidates permutation = null;
        Set mutated = null;
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            Blame sourceBlame = null;
            for (Blame blame : entry.getValue()) {
                if (sourceBlame == null) {
                    sourceBlame = blame;
                    continue;
                }
                if (sourceBlame.m_cap.getResource().equals(blame.m_cap.getResource())) continue;
                ResolverImpl.permutate(allCandidates, blame.m_reqs.get(0), this.m_importPermutations);
                ResolverImpl.permutate(allCandidates, sourceBlame.m_reqs.get(0), this.m_importPermutations);
                ResolutionException ex = new ResolutionException("Uses constraint violation. Unable to resolve resource " + Util.getSymbolicName(resource) + " [" + resource + "] because it is exposed to package '" + entry.getKey() + "' from resources " + Util.getSymbolicName(sourceBlame.m_cap.getResource()) + " [" + sourceBlame.m_cap.getResource() + "] and " + Util.getSymbolicName(blame.m_cap.getResource()) + " [" + blame.m_cap.getResource() + "] via two dependency chains.\n\nChain 1:\n" + ResolverImpl.toStringBlame(rc, allCandidates, sourceBlame) + "\n\nChain 2:\n" + ResolverImpl.toStringBlame(rc, allCandidates, blame), null, Collections.singleton(blame.m_reqs.get(0)));
                this.m_logger.log(4, "Candidate permutation failed due to a conflict with a fragment import; will try another if possible.", ex);
                throw ex;
            }
        }
        for (Map.Entry<String, Object> entry : pkgs.m_exportedPkgs.entrySet()) {
            String pkgName = entry.getKey();
            Blame exportBlame = (Blame)entry.getValue();
            if (!pkgs.m_usedPkgs.containsKey(pkgName)) continue;
            block5: for (Blame usedBlame : pkgs.m_usedPkgs.get(pkgName)) {
                Requirement req;
                if (this.isCompatible(rc, exportBlame.m_cap, usedBlame.m_cap, resourcePkgMap)) continue;
                permutation = permutation != null ? permutation : allCandidates.copy();
                rethrow = rethrow != null ? rethrow : new ResolutionException("Uses constraint violation. Unable to resolve resource " + Util.getSymbolicName(resource) + " [" + resource + "] because it exports package '" + pkgName + "' and is also exposed to it from resource " + Util.getSymbolicName(usedBlame.m_cap.getResource()) + " [" + usedBlame.m_cap.getResource() + "] via the following dependency chain:\n\n" + ResolverImpl.toStringBlame(rc, allCandidates, usedBlame), null, null);
                mutated = mutated != null ? mutated : new HashSet();
                for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0 && !mutated.contains(req = usedBlame.m_reqs.get(reqIdx)); --reqIdx) {
                    List<Capability> candidates = permutation.getCandidates(req);
                    if (candidates == null || candidates.size() <= 1) continue;
                    mutated.add(req);
                    candidates.remove(0);
                    continue block5;
                }
            }
            if (rethrow == null) continue;
            if (mutated.size() > 0) {
                this.m_usesPermutations.add(permutation);
            }
            this.m_logger.log(4, "Candidate permutation failed due to a conflict between an export and import; will try another if possible.", rethrow);
            throw rethrow;
        }
        for (Map.Entry<String, Object> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame importBlame : (List)entry.getValue()) {
                Requirement req;
                String pkgName = entry.getKey();
                if (!pkgs.m_usedPkgs.containsKey(pkgName)) continue;
                block9: for (Blame usedBlame : pkgs.m_usedPkgs.get(pkgName)) {
                    Requirement req2;
                    if (this.isCompatible(rc, importBlame.m_cap, usedBlame.m_cap, resourcePkgMap)) continue;
                    permutation = permutation != null ? permutation : allCandidates.copy();
                    rethrow = rethrow != null ? rethrow : new ResolutionException("Uses constraint violation. Unable to resolve resource " + Util.getSymbolicName(resource) + " [" + resource + "] because it is exposed to package '" + pkgName + "' from resources " + Util.getSymbolicName(importBlame.m_cap.getResource()) + " [" + importBlame.m_cap.getResource() + "] and " + Util.getSymbolicName(usedBlame.m_cap.getResource()) + " [" + usedBlame.m_cap.getResource() + "] via two dependency chains.\n\nChain 1:\n" + ResolverImpl.toStringBlame(rc, allCandidates, importBlame) + "\n\nChain 2:\n" + ResolverImpl.toStringBlame(rc, allCandidates, usedBlame), null, null);
                    mutated = mutated != null ? mutated : new HashSet();
                    for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0 && !mutated.contains(req2 = usedBlame.m_reqs.get(reqIdx)); --reqIdx) {
                        List<Capability> candidates = permutation.getCandidates(req2);
                        if (candidates == null || candidates.size() <= 1) continue;
                        mutated.add(req2);
                        candidates.remove(0);
                        continue block9;
                    }
                }
                if (rethrow == null) continue;
                if (mutated.size() > 0) {
                    this.m_usesPermutations.add(permutation);
                }
                if (!mutated.contains(req = importBlame.m_reqs.get(0))) {
                    ResolverImpl.permutateIfNeeded(allCandidates, req, this.m_importPermutations);
                }
                this.m_logger.log(4, "Candidate permutation failed due to a conflict between imports; will try another if possible.", rethrow);
                throw rethrow;
            }
        }
        resultCache.put(resource, Boolean.TRUE);
        int permCount = this.m_usesPermutations.size() + this.m_importPermutations.size();
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame importBlame : entry.getValue()) {
                if (resource.equals(importBlame.m_cap.getResource())) continue;
                try {
                    this.checkPackageSpaceConsistency(rc, false, importBlame.m_cap.getResource(), allCandidates, resourcePkgMap, resultCache);
                }
                catch (ResolutionException ex) {
                    if (permCount == this.m_usesPermutations.size() + this.m_importPermutations.size()) {
                        Requirement req = importBlame.m_reqs.get(0);
                        ResolverImpl.permutate(allCandidates, req, this.m_importPermutations);
                    }
                    throw ex;
                }
            }
        }
    }

    private static void permutate(Candidates allCandidates, Requirement req, List<Candidates> permutations) {
        List<Capability> candidates = allCandidates.getCandidates(req);
        if (candidates.size() > 1) {
            Candidates perm = allCandidates.copy();
            candidates = perm.getCandidates(req);
            candidates.remove(0);
            permutations.add(perm);
        }
    }

    private static void permutateIfNeeded(Candidates allCandidates, Requirement req, List<Candidates> permutations) {
        List<Capability> candidates = allCandidates.getCandidates(req);
        if (candidates.size() > 1) {
            boolean permutated = false;
            for (Candidates existingPerm : permutations) {
                List<Capability> existingPermCands = existingPerm.getCandidates(req);
                if (existingPermCands.get(0).equals(candidates.get(0))) continue;
                permutated = true;
            }
            if (!permutated) {
                ResolverImpl.permutate(allCandidates, req, permutations);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void calculateExportedPackages(ResolveContext rc, Resource resource, Candidates allCandidates, Map<Resource, Packages> resourcePkgMap) {
        Packages packages = resourcePkgMap.get(resource);
        if (packages != null) {
            return;
        }
        packages = new Packages(resource);
        Wiring wiring = (Wiring)rc.getWirings().get(resource);
        List caps = wiring != null ? wiring.getResourceCapabilities(null) : resource.getCapabilities(null);
        HashMap<String, void> exports = new HashMap<String, void>(caps.size());
        for (Capability capability : caps) {
            void var9_9;
            if (!capability.getNamespace().equals("osgi.wiring.package")) continue;
            if (!capability.getResource().equals(resource)) {
                WrappedCapability wrappedCapability = new WrappedCapability(resource, capability);
            }
            exports.put((String)var9_9.getAttributes().get("osgi.wiring.package"), var9_9);
        }
        if (!exports.isEmpty()) {
            if (wiring == null) {
                for (Requirement requirement : resource.getRequirements(null)) {
                    List<Capability> cands;
                    if (!requirement.getNamespace().equals("osgi.wiring.package") || (cands = allCandidates.getCandidates(requirement)) == null || cands.isEmpty()) continue;
                    String pkgName = (String)cands.get(0).getAttributes().get("osgi.wiring.package");
                    exports.remove(pkgName);
                }
            }
            for (Map.Entry entry : exports.entrySet()) {
                packages.m_exportedPkgs.put((String)entry.getKey(), new Blame((Capability)entry.getValue(), null));
            }
        }
        resourcePkgMap.put(resource, packages);
    }

    private boolean isCompatible(ResolveContext rc, Capability currentCap, Capability candCap, Map<Resource, Packages> resourcePkgMap) {
        if (currentCap != null && candCap != null) {
            List<Capability> candSources;
            if (currentCap.equals(candCap)) {
                return true;
            }
            List<Capability> currentSources = this.getPackageSources(rc, currentCap, resourcePkgMap);
            return currentSources.containsAll(candSources = this.getPackageSources(rc, candCap, resourcePkgMap)) || candSources.containsAll(currentSources);
        }
        return true;
    }

    private List<Capability> getPackageSources(ResolveContext rc, Capability cap, Map<Resource, Packages> resourcePkgMap) {
        if (cap.getNamespace().equals("osgi.wiring.package")) {
            List<Capability> sources = this.m_packageSourcesCache.get(cap);
            if (sources == null) {
                sources = ResolverImpl.getPackageSourcesInternal(rc, cap, resourcePkgMap, new ArrayList<Capability>(), new HashSet<Capability>());
                this.m_packageSourcesCache.put(cap, sources);
            }
            return sources;
        }
        String uses = (String)cap.getDirectives().get("uses");
        if (uses != null && uses.length() > 0) {
            return Collections.singletonList(cap);
        }
        return Collections.EMPTY_LIST;
    }

    private static List<Capability> getPackageSourcesInternal(ResolveContext rc, Capability cap, Map<Resource, Packages> resourcePkgMap, List<Capability> sources, Set<Capability> cycleMap) {
        if (cap.getNamespace().equals("osgi.wiring.package")) {
            if (cycleMap.contains(cap)) {
                return sources;
            }
            cycleMap.add(cap);
            String pkgName = cap.getAttributes().get("osgi.wiring.package").toString();
            Wiring wiring = (Wiring)rc.getWirings().get(cap.getResource());
            List caps = wiring != null ? wiring.getResourceCapabilities(null) : cap.getResource().getCapabilities(null);
            for (Capability sourceCap : caps) {
                if (!sourceCap.getNamespace().equals("osgi.wiring.package") || !sourceCap.getAttributes().get("osgi.wiring.package").equals(pkgName)) continue;
                if (!cap.getResource().equals(sourceCap.getResource())) {
                    sources.add((Capability)new WrappedCapability(cap.getResource(), sourceCap));
                    continue;
                }
                sources.add(sourceCap);
            }
            Packages pkgs = resourcePkgMap.get(cap.getResource());
            List<Blame> required = pkgs.m_requiredPkgs.get(pkgName);
            if (required != null) {
                for (Blame blame : required) {
                    ResolverImpl.getPackageSourcesInternal(rc, blame.m_cap, resourcePkgMap, sources, cycleMap);
                }
            }
        }
        return sources;
    }

    private static Resource getDeclaredResource(Resource resource) {
        if (resource instanceof WrappedResource) {
            return ((WrappedResource)resource).getDeclaredResource();
        }
        return resource;
    }

    private static Capability getDeclaredCapability(Capability c) {
        if (c instanceof HostedCapability) {
            return ((HostedCapability)c).getDeclaredCapability();
        }
        return c;
    }

    private static Requirement getDeclaredRequirement(Requirement r) {
        if (r instanceof WrappedRequirement) {
            return ((WrappedRequirement)r).getDeclaredRequirement();
        }
        return r;
    }

    private static Map<Resource, List<Wire>> populateWireMap(ResolveContext rc, Resource resource, Map<Resource, Packages> resourcePkgMap, Map<Resource, List<Wire>> wireMap, Candidates allCandidates) {
        Resource unwrappedResource = ResolverImpl.getDeclaredResource(resource);
        if (!rc.getWirings().containsKey(unwrappedResource) && !wireMap.containsKey(unwrappedResource)) {
            wireMap.put(unwrappedResource, Collections.EMPTY_LIST);
            ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
            ArrayList<WireImpl> bundleWires = new ArrayList<WireImpl>();
            ArrayList<WireImpl> capabilityWires = new ArrayList<WireImpl>();
            for (Requirement req : resource.getRequirements(null)) {
                Capability cand;
                List<Capability> cands = allCandidates.getCandidates(req);
                if (cands == null || cands.size() <= 0 || (cand = cands.get(0)).getNamespace().startsWith("osgi.wiring.") && resource.equals(cand.getResource())) continue;
                if (!rc.getWirings().containsKey(cand.getResource())) {
                    ResolverImpl.populateWireMap(rc, cand.getResource(), resourcePkgMap, wireMap, allCandidates);
                }
                WireImpl wire = new WireImpl(unwrappedResource, ResolverImpl.getDeclaredRequirement(req), ResolverImpl.getDeclaredResource(cand.getResource()), ResolverImpl.getDeclaredCapability(cand));
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    packageWires.add(wire);
                    continue;
                }
                if (req.getNamespace().equals("osgi.wiring.bundle")) {
                    bundleWires.add(wire);
                    continue;
                }
                capabilityWires.add(wire);
            }
            packageWires.addAll(bundleWires);
            packageWires.addAll(capabilityWires);
            wireMap.put(unwrappedResource, packageWires);
            if (resource instanceof WrappedResource) {
                List<Resource> fragments = ((WrappedResource)resource).getFragments();
                for (Resource fragment : fragments) {
                    ArrayList<Wire> fragmentWires = wireMap.get(fragment);
                    fragmentWires = fragmentWires == null ? new ArrayList<Wire>() : fragmentWires;
                    for (Requirement req : fragment.getRequirements(null)) {
                        Wire wire;
                        if (ResolverImpl.isPayload(req)) continue;
                        if (req.getNamespace().equals("osgi.wiring.host")) {
                            fragmentWires.add(new WireImpl(ResolverImpl.getDeclaredResource(fragment), req, unwrappedResource, (Capability)unwrappedResource.getCapabilities("osgi.wiring.host").get(0)));
                            continue;
                        }
                        if (rc.getWirings().containsKey(fragment) || wireMap.containsKey(fragment) || (wire = ResolverImpl.createWire(req, allCandidates)) == null) continue;
                        fragmentWires.add(wire);
                    }
                    wireMap.put(fragment, fragmentWires);
                }
            }
        }
        return wireMap;
    }

    private static Wire createWire(Requirement requirement, Candidates allCandidates) {
        List<Capability> candidates = allCandidates.getCandidates(requirement);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        Capability cand = candidates.get(0);
        return new WireImpl(ResolverImpl.getDeclaredResource(requirement.getResource()), ResolverImpl.getDeclaredRequirement(requirement), ResolverImpl.getDeclaredResource(cand.getResource()), ResolverImpl.getDeclaredCapability(cand));
    }

    private static boolean isPayload(Requirement fragmentReq) {
        if ("osgi.ee".equals(fragmentReq.getNamespace())) {
            return false;
        }
        return !"osgi.wiring.host".equals(fragmentReq.getNamespace());
    }

    private static Map<Resource, List<Wire>> populateDynamicWireMap(ResolveContext rc, Resource resource, Requirement dynReq, Map<Resource, Packages> resourcePkgMap, Map<Resource, List<Wire>> wireMap, Candidates allCandidates) {
        wireMap.put(resource, Collections.EMPTY_LIST);
        ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
        List<Capability> candCaps = allCandidates.getCandidates(dynReq);
        Capability dynCand = candCaps.get(0);
        if (!rc.getWirings().containsKey(dynCand.getResource())) {
            ResolverImpl.populateWireMap(rc, dynCand.getResource(), resourcePkgMap, wireMap, allCandidates);
        }
        packageWires.add(new WireImpl(resource, dynReq, ResolverImpl.getDeclaredResource(dynCand.getResource()), ResolverImpl.getDeclaredCapability(dynCand)));
        wireMap.put(resource, packageWires);
        return wireMap;
    }

    private static void dumpResourcePkgMap(ResolveContext rc, Map<Resource, Packages> resourcePkgMap) {
        System.out.println("+++RESOURCE PKG MAP+++");
        for (Map.Entry<Resource, Packages> entry : resourcePkgMap.entrySet()) {
            ResolverImpl.dumpResourcePkgs(rc, entry.getKey(), entry.getValue());
        }
    }

    private static void dumpResourcePkgs(ResolveContext rc, Resource resource, Packages packages) {
        Wiring wiring = (Wiring)rc.getWirings().get(resource);
        System.out.println(resource + " (" + (wiring != null ? "RESOLVED)" : "UNRESOLVED)"));
        System.out.println("  EXPORTED");
        for (Map.Entry<String, Blame> entry : packages.m_exportedPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  IMPORTED");
        for (Map.Entry<String, Object> entry : packages.m_importedPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  REQUIRED");
        for (Map.Entry<String, Object> entry : packages.m_requiredPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  USED");
        for (Map.Entry<String, Object> entry : packages.m_usedPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
    }

    private static String toStringBlame(ResolveContext rc, Candidates allCandidates, Blame blame) {
        StringBuffer sb = new StringBuffer();
        if (blame.m_reqs != null && !blame.m_reqs.isEmpty()) {
            for (int i = 0; i < blame.m_reqs.size(); ++i) {
                Requirement req = blame.m_reqs.get(i);
                sb.append("  ");
                sb.append(Util.getSymbolicName(req.getResource()));
                sb.append(" [");
                sb.append(req.getResource().toString());
                sb.append("]\n");
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    sb.append("    import: ");
                } else {
                    sb.append("    require: ");
                }
                sb.append((String)req.getDirectives().get("filter"));
                sb.append("\n     |");
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    sb.append("\n    export: ");
                } else {
                    sb.append("\n    provide: ");
                }
                if (i + 1 < blame.m_reqs.size()) {
                    Capability cap = ResolverImpl.getSatisfyingCapability(rc, allCandidates, blame.m_reqs.get(i));
                    if (cap.getNamespace().equals("osgi.wiring.package")) {
                        sb.append("osgi.wiring.package");
                        sb.append("=");
                        sb.append(cap.getAttributes().get("osgi.wiring.package").toString());
                        Capability usedCap = ResolverImpl.getSatisfyingCapability(rc, allCandidates, blame.m_reqs.get(i + 1));
                        sb.append("; uses:=");
                        sb.append(usedCap.getAttributes().get("osgi.wiring.package"));
                    } else {
                        sb.append(cap);
                    }
                    sb.append("\n");
                    continue;
                }
                Capability export = ResolverImpl.getSatisfyingCapability(rc, allCandidates, blame.m_reqs.get(i));
                sb.append(export.getNamespace());
                sb.append("=");
                sb.append(export.getAttributes().get(export.getNamespace()).toString());
                if (export.getNamespace().equals("osgi.wiring.package") && !export.getAttributes().get("osgi.wiring.package").equals(blame.m_cap.getAttributes().get("osgi.wiring.package"))) {
                    sb.append("; uses:=");
                    sb.append(blame.m_cap.getAttributes().get("osgi.wiring.package"));
                    sb.append("\n    export: ");
                    sb.append("osgi.wiring.package");
                    sb.append("=");
                    sb.append(blame.m_cap.getAttributes().get("osgi.wiring.package").toString());
                }
                sb.append("\n  ");
                sb.append(Util.getSymbolicName(blame.m_cap.getResource()));
                sb.append(" [");
                sb.append(blame.m_cap.getResource().toString());
                sb.append("]");
            }
        } else {
            sb.append(blame.m_cap.getResource().toString());
        }
        return sb.toString();
    }

    private static Capability getSatisfyingCapability(ResolveContext rc, Candidates allCandidates, Requirement req) {
        Capability cap = null;
        List<Capability> cands = allCandidates.getCandidates(req);
        if (cands != null) {
            cap = cands.get(0);
        } else if (rc.getWirings().containsKey(req.getResource())) {
            List wires = ((Wiring)rc.getWirings().get(req.getResource())).getRequiredResourceWires(null);
            req = ResolverImpl.getDeclaredRequirement(req);
            for (Wire w : wires) {
                if (!w.getRequirement().equals(req)) continue;
                cap = w.getCapability();
                break;
            }
        }
        return cap;
    }

    private static class Blame {
        public final Capability m_cap;
        public final List<Requirement> m_reqs;

        public Blame(Capability cap, List<Requirement> reqs) {
            this.m_cap = cap;
            this.m_reqs = reqs;
        }

        public String toString() {
            return this.m_cap.getResource() + "." + this.m_cap.getAttributes().get("osgi.wiring.package") + (this.m_reqs == null || this.m_reqs.isEmpty() ? " NO BLAME" : " BLAMED ON " + this.m_reqs);
        }

        public boolean equals(Object o) {
            return o instanceof Blame && ((Object)this.m_reqs).equals(((Blame)o).m_reqs) && this.m_cap.equals(((Blame)o).m_cap);
        }
    }

    private static class Packages {
        private final Resource m_resource;
        public final Map<String, Blame> m_exportedPkgs = new HashMap<String, Blame>();
        public final Map<String, List<Blame>> m_importedPkgs = new HashMap<String, List<Blame>>();
        public final Map<String, List<Blame>> m_requiredPkgs = new HashMap<String, List<Blame>>();
        public final Map<String, List<Blame>> m_usedPkgs = new HashMap<String, List<Blame>>();
        public boolean m_isCalculated = false;

        public Packages(Resource resource) {
            this.m_resource = resource;
        }
    }
}

