/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment;

import java.util.Dictionary;
import java.util.Properties;
import javax.management.MBeanServer;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.DeploymentRegistryService;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorService;
import org.jboss.osgi.deployment.internal.DeploymentRegistryServiceImpl;
import org.jboss.osgi.deployment.internal.LifecycleInterceptorServiceImpl;
import org.jboss.osgi.deployment.internal.SystemDeployerService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class DeploymentServicesActivator {
    public void start(BundleContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null BundleContext");
        }
        DeploymentRegistryServiceImpl registry = new DeploymentRegistryServiceImpl(context);
        context.registerService(DeploymentRegistryService.class.getName(), (Object)registry, null);
        Properties props = new Properties();
        props.put("provider", "system");
        final SystemDeployerService deployerService = new SystemDeployerService(context);
        context.registerService(DeployerService.class.getName(), (Object)deployerService, (Dictionary)props);
        LifecycleInterceptorServiceImpl service = new LifecycleInterceptorServiceImpl(context);
        context.registerService(LifecycleInterceptorService.class.getName(), (Object)service, null);
        ServiceTracker serviceTracker = new ServiceTracker(context, DeployerService.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                DeployerService service = (DeployerService)super.addingService(reference);
                ServiceReference sref = this.context.getServiceReference(MBeanServer.class.getName());
                if (sref != null) {
                    MBeanServer mbeanServer = (MBeanServer)this.context.getService(sref);
                    deployerService.registerDeployerServiceMBean(this.context, mbeanServer);
                }
                return service;
            }

            public void removedService(ServiceReference reference, Object service) {
                ServiceReference sref = this.context.getServiceReference(MBeanServer.class.getName());
                if (sref != null) {
                    MBeanServer mbeanServer = (MBeanServer)this.context.getService(sref);
                    deployerService.unregisterDeployerServiceMBean(mbeanServer);
                }
                super.removedService(reference, service);
            }
        };
        serviceTracker.open();
    }

    public void stop(BundleContext context) {
    }
}

