/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorService;
import org.jboss.osgi.deployment.internal.InterceptorWrapper;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLifecycleInterceptorService
implements LifecycleInterceptorService {
    private Logger log = LoggerFactory.getLogger(AbstractLifecycleInterceptorService.class);
    private BundleContext context;
    private List<LifecycleInterceptor> interceptorChain = new ArrayList<LifecycleInterceptor>();

    protected AbstractLifecycleInterceptorService(BundleContext context) {
        if (context == null) {
            throw new IllegalStateException("Null context");
        }
        this.context = context;
        ServiceTracker tracker = new ServiceTracker(context, LifecycleInterceptor.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                LifecycleInterceptor interceptor = (LifecycleInterceptor)super.addingService(reference);
                AbstractLifecycleInterceptorService.this.addInterceptor(interceptor);
                return interceptor;
            }

            public void removedService(ServiceReference reference, Object service) {
                super.removedService(reference, service);
                LifecycleInterceptor interceptor = (LifecycleInterceptor)service;
                AbstractLifecycleInterceptorService.this.removeInterceptor(interceptor);
            }
        };
        tracker.open();
    }

    public BundleContext getSystemContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInterceptor(LifecycleInterceptor interceptor) {
        if (interceptor == null) {
            throw new IllegalArgumentException("Null interceptor");
        }
        this.log.debug("Add interceptor: " + new InterceptorWrapper(interceptor));
        List<LifecycleInterceptor> list = this.interceptorChain;
        synchronized (list) {
            HashSet<LifecycleInterceptor> unsortedSet = new HashSet<LifecycleInterceptor>();
            unsortedSet.addAll(this.interceptorChain);
            unsortedSet.add(interceptor);
            ArrayList<LifecycleInterceptor> sortedList = new ArrayList<LifecycleInterceptor>();
            Iterator itUnsorted = unsortedSet.iterator();
            while (itUnsorted.hasNext()) {
                LifecycleInterceptor aux = (LifecycleInterceptor)itUnsorted.next();
                if (aux.getInput() != null) continue;
                this.addWithRelativeOrder(sortedList, aux);
                itUnsorted.remove();
            }
            HashSet providedOutputs = new HashSet();
            for (LifecycleInterceptor aux : sortedList) {
                Set<Class<?>> auxOutput = aux.getOutput();
                if (auxOutput == null) continue;
                providedOutputs.addAll(auxOutput);
            }
            itUnsorted = unsortedSet.iterator();
            while (itUnsorted.hasNext()) {
                LifecycleInterceptor aux = (LifecycleInterceptor)itUnsorted.next();
                Set<Class<?>> input = aux.getInput();
                if (input == null) {
                    throw new IllegalStateException("Interceptor with no inputs should have been added already");
                }
                if (!providedOutputs.containsAll(input)) continue;
                this.addWithRelativeOrder(sortedList, aux);
                itUnsorted.remove();
            }
            for (LifecycleInterceptor aux : unsortedSet) {
                this.addWithRelativeOrder(sortedList, aux);
            }
            StringBuffer buffer = new StringBuffer();
            for (LifecycleInterceptor aux : sortedList) {
                InterceptorWrapper wrapper = new InterceptorWrapper(aux);
                buffer.append("\n  " + wrapper.toLongString());
            }
            this.log.debug("Resulting interceptor chain" + buffer.toString());
            this.interceptorChain.clear();
            this.interceptorChain.addAll(sortedList);
        }
    }

    private void addWithRelativeOrder(List<LifecycleInterceptor> sortedList, LifecycleInterceptor interceptor) {
        HashSet providedOutputs = new HashSet();
        int relOrder = interceptor.getRelativeOrder();
        Set<Class<?>> input = interceptor.getInput();
        for (int i = 0; i < sortedList.size(); ++i) {
            boolean inputsProvided;
            LifecycleInterceptor aux = sortedList.get(i);
            int auxOrder = aux.getRelativeOrder();
            boolean bl = inputsProvided = input == null || providedOutputs.containsAll(input);
            if (inputsProvided && relOrder <= auxOrder) {
                sortedList.add(i, interceptor);
                return;
            }
            Set<Class<?>> auxOutput = aux.getOutput();
            if (auxOutput == null) continue;
            providedOutputs.addAll(auxOutput);
        }
        sortedList.add(interceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInterceptor(LifecycleInterceptor interceptor) {
        if (interceptor == null) {
            throw new IllegalArgumentException("Null interceptor");
        }
        this.log.debug("Remove interceptor: " + new InterceptorWrapper(interceptor));
        List<LifecycleInterceptor> list = this.interceptorChain;
        synchronized (list) {
            this.interceptorChain.remove(interceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LifecycleInterceptor> getInterceptorChain() {
        List<LifecycleInterceptor> list = this.interceptorChain;
        synchronized (list) {
            return Collections.unmodifiableList(this.interceptorChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleStateChange(int state, Bundle bundle) {
        List<LifecycleInterceptor> list = this.interceptorChain;
        synchronized (list) {
            if (this.interceptorChain.size() == 0) {
                return;
            }
            InvocationContext inv = this.getInvocationContext(bundle);
            if (inv == null) {
                throw new IllegalStateException("Cannot get invocation context for: " + bundle);
            }
            for (LifecycleInterceptor aux : this.interceptorChain) {
                Set<Class<?>> input = aux.getInput();
                boolean doInvocation = true;
                if (input != null) {
                    for (Class<?> clazz : input) {
                        if (inv.getAttachment(clazz) != null) continue;
                        doInvocation = false;
                        break;
                    }
                }
                if (!doInvocation) continue;
                InterceptorWrapper wrapper = new InterceptorWrapper(aux);
                String stateName = ConstantsHelper.bundleState((int)state);
                String location = inv.getBundle().getLocation();
                this.log.trace("Invoke: " + wrapper + " with state " + stateName + " on " + location);
                aux.invoke(state, inv);
            }
        }
    }

    protected abstract InvocationContext getInvocationContext(Bundle var1);
}

