/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.internal;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentRegistryService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentRegistryServiceImpl
implements DeploymentRegistryService {
    private Logger log = LoggerFactory.getLogger(DeploymentRegistryServiceImpl.class);
    private List<Deployment> deployments = new CopyOnWriteArrayList<Deployment>();

    public DeploymentRegistryServiceImpl(BundleContext context) {
    }

    @Override
    public List<Deployment> getDeployments() {
        return Collections.unmodifiableList(this.deployments);
    }

    @Override
    public void registerDeployment(Deployment dep) {
        this.log.debug("Register: " + dep);
        this.deployments.add(dep);
    }

    @Override
    public void unregisterDeployment(Deployment dep) {
        this.log.debug("Unregister: " + dep);
        this.deployments.remove(dep);
    }

    @Override
    public Deployment getDeployment(String symbolicName, Version version) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("Cannot obtain bundle deployment for null symbolic name");
        }
        Deployment dep = null;
        for (Deployment auxDep : this.deployments) {
            String auxName = auxDep.getSymbolicName();
            String auxVersion = auxDep.getVersion();
            if (!symbolicName.equals(auxName) || !version.equals((Object)auxVersion)) continue;
            dep = auxDep;
            break;
        }
        return dep;
    }

    @Override
    public Deployment getDeployment(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Cannot obtain bundle deployment for: null");
        }
        Deployment dep = null;
        for (Deployment auxDep : this.deployments) {
            if (!url.equals(auxDep.getLocation())) continue;
            dep = auxDep;
            break;
        }
        return dep;
    }
}

