/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.integration.jbossas;

//$Id: MicrocontainerDeployerServiceBean.java 95913 2009-11-02 12:18:46Z thomas.diesler@jboss.com $

import java.util.Properties;

import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.microcontainer.AbstractMicrocontainerDeployerService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Constants;
import org.osgi.framework.ServiceRegistration;

/**
 * An implementation of the {@link DeployerService} which is installed as MC bean in jbossas.
 * 
 * @author thomas.diesler@jboss.com
 * @since 05-May-2009
 */
public class MicrocontainerDeployerServiceBean extends AbstractMicrocontainerDeployerService
{
   // Provide logging
   private static Logger log = Logger.getLogger(MicrocontainerDeployerServiceBean.class);

   private MainDeployer mainDeployer;
   private BundleContext context;
   private ServiceRegistration serviceReg;

   public MainDeployer getMainDeployer()
   {
      return mainDeployer;
   }

   public void setMainDeployer(MainDeployer mainDeployer)
   {
      this.mainDeployer = mainDeployer;
   }

   public BundleContext getBundleContext()
   {
      return context;
   }

   public void setBundleContext(BundleContext context)
   {
      this.context = context;
   }

   public void start()
   {
      // Register the DeployerService
      Properties props = new Properties();
      props.setProperty("provider", "microcontainer");
      props.put(Constants.SERVICE_RANKING, Integer.MAX_VALUE);
      serviceReg = context.registerService(DeployerService.class.getName(), this, props);
      log.debug("DeployerService registered");
   }

   void stop()
   {
      if (serviceReg != null)
      {
         serviceReg.unregister();
         serviceReg = null;
      }
   }
}