/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.integration.jbossas;


//$Id: MicrocontainerServiceBean.java 97228 2009-12-01 13:48:30Z thomas.diesler@jboss.com $

import javax.management.MBeanServer;

import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.osgi.microcontainer.AbstractMicrocontainerService;
import org.jboss.osgi.spi.management.MicrocontainerServiceMBean;
import org.jboss.osgi.spi.service.MicrocontainerService;
import org.osgi.framework.BundleContext;

/**
 * An implementation of the {@link MicrocontainerService}
 * which is installed as MC bean in jbossas.
 * 
 * @author thomas.diesler@jboss.com
 * @since 05-May-2009
 */
public class MicrocontainerServiceBean extends AbstractMicrocontainerService implements MicrocontainerServiceMBean
{
   // Provide logging
   private static Logger log = Logger.getLogger(MicrocontainerServiceBean.class);

   private BundleContext context;
   private MBeanServer mbeanServer;
   private Kernel kernel;

   public void setBundleContext(BundleContext bundleContext)
   {
      this.context = bundleContext;
   }

   public void setMbeanServer(MBeanServer mbeanServer)
   {
      this.mbeanServer = mbeanServer;
   }

   public void setKernel(Kernel kernel)
   {
      this.kernel = kernel;
   }

   public Kernel getKernel()
   {
      return kernel;
   }

   public void start() throws Exception
   {
      Kernel kernel = getKernel();
      KernelController controller = kernel.getController();

      // Preregister some MC beans
      installBean(controller, BEAN_BUNDLE_CONTEXT, context);
      installBean(controller, BEAN_KERNEL, kernel);
      installBean(controller, BEAN_KERNEL_CONTROLLER, controller);
      installBean(controller, BEAN_MBEAN_SERVER, mbeanServer);

      // Register the MicrocontainerService
      log.debug("Register MicrocontainerService");
      context.registerService(MicrocontainerService.class.getName(), this, null);
      log.debug("MicrocontainerService registered");

      // Register the MicrocontainerServiceMBean
      registerMicrocontainerServiceMBean(mbeanServer);
      log.debug("MicrocontainerServiceMBean registered");
   }

   void stop()
   {
      unregisterMicrocontainerServiceMBean(mbeanServer);
   }
}