/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.serviceloader.internal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class ServiceLoaderInterceptor
extends AbstractLifecycleInterceptor {
    private static final Logger log = Logger.getLogger(ServiceLoaderInterceptor.class);

    public void invoke(int state, InvocationContext context) {
        if (state == 8) {
            Bundle bundle = context.getBundle();
            if (bundle.getEntry("META-INF/services/") == null) {
                return;
            }
            Enumeration entryPaths = bundle.getEntryPaths("META-INF/services/");
            while (entryPaths.hasMoreElements()) {
                String entryPath = (String)entryPaths.nextElement();
                if (entryPath.endsWith("/")) continue;
                this.processServicesEntryPath(context, entryPath);
            }
        }
    }

    private void processServicesEntryPath(InvocationContext context, String entryPath) {
        Bundle bundle = context.getBundle();
        VirtualFile root = context.getRoot();
        try {
            String serviceName = entryPath.substring("META-INF/services/".length());
            Class serviceClass = bundle.loadClass(serviceName);
            VirtualFile child = root.getChild(entryPath);
            InputStream inStream = child.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
            String implClassName = br.readLine();
            while (implClassName != null) {
                int hashIndex = implClassName.indexOf("#");
                if (hashIndex > 0) {
                    implClassName = implClassName.substring(0, hashIndex);
                }
                if ((implClassName = implClassName.trim()).length() > 0) {
                    Class implClass = bundle.loadClass(implClassName);
                    if (!serviceClass.isAssignableFrom(implClass)) {
                        log.warn((Object)("Not assignable: " + implClassName));
                        continue;
                    }
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    props.put("version", bundle.getVersion().toString());
                    String vendor = (String)bundle.getHeaders().get("Bundle-Vendor");
                    props.put("service.vendor", vendor != null ? vendor : "anonymous");
                    MetaInfServiceFactory factory = new MetaInfServiceFactory(implClass);
                    BundleContext bundleContext = bundle.getBundleContext();
                    bundleContext.registerService(serviceName, (Object)factory, props);
                }
                implClassName = br.readLine();
            }
            br.close();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            log.error((Object)("Cannot process: " + entryPath), (Throwable)ex);
        }
    }

    static class MetaInfServiceFactory
    implements ServiceFactory {
        private Class<?> serviceClass;

        public MetaInfServiceFactory(Class<?> serviceClass) {
            this.serviceClass = serviceClass;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            try {
                Object serviceInstance = this.serviceClass.newInstance();
                return serviceInstance;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot instanciate service", ex);
            }
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

