/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.osgi.spi.SPILogger;
import org.jboss.osgi.spi.SPIMessages;
import org.jboss.osgi.spi.framework.GenericFrameworkWrapper;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.util.ServiceLoader;
import org.jboss.osgi.spi.util.StringPropertyReplacer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class PropertiesBootstrapProvider
implements OSGiBootstrapProvider {
    public static final String OSGI_FRAMEWORK_CONFIG = "jboss.osgi.framework.properties";
    public static final String DEFAULT_OSGI_FRAMEWORK_PROPERTIES = "jboss-osgi-framework.properties";
    public static final String PROP_OSGI_FRAMEWORK_AUTO_INSTALL = "org.jboss.osgi.framework.autoInstall";
    public static final String PROP_OSGI_FRAMEWORK_AUTO_START = "org.jboss.osgi.framework.autoStart";
    public static final String PROP_OSGI_FRAMEWORK_EXTRA = "org.jboss.osgi.framework.extra";
    private static Set<String> internalProps = new HashSet<String>();
    private Framework framework;
    private boolean configured;

    @Override
    public void configure() {
        this.configureInternal(System.getProperty(OSGI_FRAMEWORK_CONFIG, DEFAULT_OSGI_FRAMEWORK_PROPERTIES));
    }

    @Override
    public void configure(String resourceConfig) {
        if (resourceConfig == null) {
            throw SPIMessages.MESSAGES.illegalArgumentNull("resourceConfig");
        }
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
        if (urlConfig == null) {
            throw SPIMessages.MESSAGES.illegalStateCannotFindResource(resourceConfig);
        }
        this.configure(urlConfig);
    }

    @Override
    public void configure(URL urlConfig) {
        if (urlConfig == null) {
            throw SPIMessages.MESSAGES.illegalArgumentNull("config url");
        }
        Map<String, String> props = this.getBootstrapProperties(urlConfig);
        this.initFrameworkInstance(props);
    }

    @Override
    public void configure(InputStream streamConfig) {
        Map<String, String> props = this.getBootstrapProperties(streamConfig);
        this.initFrameworkInstance(props);
    }

    private void configureInternal(String resourceConfig) {
        Map<String, String> props;
        if (resourceConfig == null) {
            throw SPIMessages.MESSAGES.illegalArgumentNull("resourceConfig");
        }
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
        if (urlConfig != null) {
            props = this.getBootstrapProperties(urlConfig);
        } else {
            props = new HashMap<String, String>();
            SPILogger.LOGGER.debugf("Bootstrap using framework defaults", new Object[0]);
        }
        this.initFrameworkInstance(props);
    }

    private void initFrameworkInstance(final Map<String, String> props) {
        Framework frameworkImpl = this.createFramework(props);
        this.framework = new GenericFrameworkWrapper<Framework>(frameworkImpl){

            @Override
            public void start() throws BundleException {
                Bundle bundle2;
                super.start();
                BundleContext context = this.getBundleContext();
                if (context == null) {
                    throw SPIMessages.MESSAGES.bundleCannotOptainSystemContext();
                }
                List autoInstall = PropertiesBootstrapProvider.this.getBundleURLs(props, PropertiesBootstrapProvider.PROP_OSGI_FRAMEWORK_AUTO_INSTALL);
                List autoStart = PropertiesBootstrapProvider.this.getBundleURLs(props, PropertiesBootstrapProvider.PROP_OSGI_FRAMEWORK_AUTO_START);
                HashMap<URL, Bundle> autoBundles = new HashMap<URL, Bundle>();
                for (URL bundleURL : autoStart) {
                    autoInstall.add(bundleURL);
                }
                PropertiesBootstrapProvider.this.registerSystemServices(context);
                for (URL bundleURL : autoInstall) {
                    bundle2 = context.installBundle(bundleURL.toString());
                    SPILogger.LOGGER.infoBundleInstalled(bundle2.getBundleId(), bundle2);
                    autoBundles.put(bundleURL, bundle2);
                }
                for (URL bundleURL : autoStart) {
                    bundle2 = (Bundle)autoBundles.get(bundleURL);
                    if (bundle2 == null) continue;
                    bundle2.start();
                    SPILogger.LOGGER.infoBundleStarted(bundle2.getBundleId(), bundle2);
                }
            }

            @Override
            public void stop() throws BundleException {
                PropertiesBootstrapProvider.this.unregisterSystemServices(this.getBundleContext());
                super.stop();
            }
        };
        this.configured = true;
    }

    protected Framework createFramework(Map<String, String> properties) {
        FrameworkFactory factory = ServiceLoader.loadService(FrameworkFactory.class);
        if (factory == null) {
            throw SPIMessages.MESSAGES.illegalStateCannotLoadService(FrameworkFactory.class.getName());
        }
        Framework framework = factory.newFramework(properties);
        return framework;
    }

    protected void registerSystemServices(BundleContext context) {
    }

    protected void unregisterSystemServices(BundleContext context) {
    }

    private List<URL> getBundleURLs(Map<String, String> props, String key) {
        String bundleList = props.get(key);
        if (bundleList == null) {
            bundleList = "";
        }
        ArrayList<URL> bundleURLs = new ArrayList<URL>();
        for (String bundle2 : bundleList.split("[, ]")) {
            if (bundle2.trim().length() <= 0) continue;
            URL installURL = this.toURL(bundle2);
            bundleURLs.add(installURL);
        }
        return bundleURLs;
    }

    private URL toURL(String path) {
        String realPath = StringPropertyReplacer.replaceProperties(path);
        try {
            URL pathURL = new URL(realPath);
            return pathURL;
        }
        catch (MalformedURLException ex) {
            throw SPIMessages.MESSAGES.illegalStateInvalidPath(ex, path);
        }
    }

    @Override
    public Framework getFramework() {
        if (!this.configured) {
            this.configureInternal(System.getProperty(OSGI_FRAMEWORK_CONFIG, DEFAULT_OSGI_FRAMEWORK_PROPERTIES));
        }
        return this.framework;
    }

    private Map<String, String> getBootstrapProperties(URL urlConfig) {
        Map<String, String> props = null;
        try {
            InputStream propStream = urlConfig.openStream();
            props = this.getBootstrapProperties(propStream);
            propStream.close();
        }
        catch (IOException ex) {
            throw SPIMessages.MESSAGES.illegalStateCannotConfigureFrom(ex, urlConfig);
        }
        return props;
    }

    private Map<String, String> getBootstrapProperties(InputStream propStream) {
        HashMap<String, String> propMap;
        block10: {
            if (propStream == null) {
                throw SPIMessages.MESSAGES.illegalArgumentNull("propStream");
            }
            propMap = new HashMap<String, String>();
            try {
                Properties props = new Properties();
                props.load(propStream);
                propStream.close();
                Enumeration<?> keys = props.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = props.getProperty(key);
                    value = StringPropertyReplacer.replaceProperties(value);
                    propMap.put(key, value);
                }
                String extraPropsValue = (String)propMap.get(PROP_OSGI_FRAMEWORK_EXTRA);
                if (extraPropsValue == null) break block10;
                URL extraPropsURL = null;
                try {
                    extraPropsURL = new URL(extraPropsValue);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                if (extraPropsURL == null) {
                    File propsFile = new File(extraPropsValue);
                    try {
                        extraPropsURL = propsFile.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                if (extraPropsURL == null) {
                    throw SPIMessages.MESSAGES.illegalStateInvalidPropertiesURL(extraPropsValue);
                }
                propMap.remove(PROP_OSGI_FRAMEWORK_EXTRA);
                Map<String, String> extraProps = this.getBootstrapProperties(extraPropsURL.openStream());
                propMap.putAll(extraProps);
            }
            catch (IOException ex) {
                throw SPIMessages.MESSAGES.illegalStateCannotLoadProperties(ex);
            }
        }
        return propMap;
    }

    static {
        internalProps.add(PROP_OSGI_FRAMEWORK_AUTO_INSTALL);
        internalProps.add(PROP_OSGI_FRAMEWORK_AUTO_START);
        internalProps.add(PROP_OSGI_FRAMEWORK_EXTRA);
    }
}

