/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.osgi;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.osgi.framework.Version;

public final class FrameworkManagement {
    private FrameworkManagement() {
    }

    public static void activateFramework(ModelControllerClient client) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi", "activate");
        FrameworkManagement.executeOperation(client, op);
    }

    public static String getActivationMode(ModelControllerClient client) throws Exception {
        return FrameworkManagement.readAttribute(client, "activation");
    }

    public static void setActivationMode(ModelControllerClient client, String mode) throws Exception {
        FrameworkManagement.writeAttribute(client, "activation", mode);
    }

    public static Integer getFrameworkStartLevel(ModelControllerClient client) throws Exception {
        String sl = FrameworkManagement.readAttribute(client, "startlevel");
        if (sl.trim().length() == 0) {
            return null;
        }
        return Integer.parseInt(sl);
    }

    public static void setFrameworkStartLevel(ModelControllerClient client, int i) throws Exception {
        FrameworkManagement.writeAttribute(client, "startlevel", "" + i);
    }

    public static void bundleStart(ModelControllerClient client, Object resId) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi/bundle=" + resId, "start");
        FrameworkManagement.executeOperation(client, op, true);
    }

    public static void bundleStop(ModelControllerClient client, Object resId) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi/bundle=" + resId, "stop");
        FrameworkManagement.executeOperation(client, op, true);
    }

    public static List<Long> listBundleIDs(ModelControllerClient client) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi", "read-children-names");
        op.get("child-type").set("bundle");
        ModelNode result = FrameworkManagement.executeOperation(client, op, true);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ModelNode s : result.asList()) {
            ids.add(Long.parseLong(s.asString()));
        }
        return ids;
    }

    public static Long getBundleId(ModelControllerClient client, String symbolicName, Version version) throws Exception {
        Long result = new Long(-1L);
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi", "read-resource");
        op.get("include-runtime").set("true");
        op.get("recursive").set("true");
        ModelNode bundleNode = FrameworkManagement.executeOperation(client, op).get("bundle");
        for (ModelNode node : bundleNode.asList()) {
            Version auxver;
            Property propNode = node.asProperty();
            ModelNode valueNode = propNode.getValue();
            ModelNode symbolicNameNode = valueNode.get("symbolic-name");
            if (!symbolicNameNode.asString().equals(symbolicName)) continue;
            if (version == null) {
                result = new Long(propNode.getName());
                break;
            }
            ModelNode versionNode = valueNode.get("version");
            if (!versionNode.isDefined() || !version.equals((Object)(auxver = Version.parseVersion((String)versionNode.asString())))) continue;
            result = new Long(propNode.getName());
            break;
        }
        return result;
    }

    public static String getBundleState(ModelControllerClient client, Object resId) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi/bundle=" + resId, "read-resource");
        op.get("include-runtime").set("true");
        op.get("recursive").set("true");
        ModelNode result = FrameworkManagement.executeOperation(client, op);
        return result.get("state").asString();
    }

    public static ModelNode getBundleInfo(ModelControllerClient client, Object resId) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi/bundle=" + resId, "read-resource");
        op.get("include-runtime").set("true");
        op.get("recursive").set("true");
        return FrameworkManagement.executeOperation(client, op);
    }

    public static void addCapability(ModelControllerClient client, String name, Integer startLevel) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi/capability=" + name, "add");
        op.get("startlevel").set(startLevel.toString());
        FrameworkManagement.executeOperation(client, op, true);
    }

    public static List<String> listCapabilities(ModelControllerClient client) throws Exception {
        return FrameworkManagement.listChildrenNames(client, "capability");
    }

    public static void removeCapability(ModelControllerClient client, String name) throws Exception {
        FrameworkManagement.removeResource(client, "capability", name);
    }

    public static void addProperty(ModelControllerClient client, String name, String value) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi/property=" + name, "add");
        op.get("value").set(value);
        FrameworkManagement.executeOperation(client, op, true);
    }

    public static List<String> listProperties(ModelControllerClient client) throws Exception {
        return FrameworkManagement.listChildrenNames(client, "property");
    }

    public static String readProperty(ModelControllerClient client, String name) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi/property=" + name, "read-resource");
        ModelNode result = FrameworkManagement.executeOperation(client, op);
        return result.get("value").asString();
    }

    public static void removeProperty(ModelControllerClient client, String name) throws Exception {
        FrameworkManagement.removeResource(client, "property", name);
    }

    private static List<String> listChildrenNames(ModelControllerClient client, String type) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi", "read-children-names");
        op.get("child-type").set(type);
        ModelNode result = FrameworkManagement.executeOperation(client, op);
        ArrayList<String> names = new ArrayList<String>();
        for (ModelNode n : result.asList()) {
            names.add(n.asString());
        }
        return names;
    }

    private static void removeResource(ModelControllerClient client, String type, String name) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi/" + type + "=" + name, "remove");
        FrameworkManagement.executeOperation(client, op, true);
    }

    private static String readAttribute(ModelControllerClient client, String attributeName) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi", "read-attribute");
        op.get("name").set(attributeName);
        ModelNode result = FrameworkManagement.executeOperation(client, op);
        return result.asString();
    }

    private static void writeAttribute(ModelControllerClient client, String attributeName, String value) throws Exception {
        ModelNode op = FrameworkManagement.createOpNode("subsystem=osgi", "write-attribute");
        op.get("name").set(attributeName);
        op.get("value").set(value);
        FrameworkManagement.executeOperation(client, op, true);
    }

    private static ModelNode createOpNode(String address, String operation) {
        ModelNode op = new ModelNode();
        ModelNode list = op.get("address").setEmptyList();
        if (address != null) {
            String[] pathSegments;
            for (String segment : pathSegments = address.split("/")) {
                String[] elements = segment.split("=");
                list.add(elements[0], elements[1]);
            }
        }
        op.get("operation").set(operation);
        return op;
    }

    private static ModelNode executeOperation(ModelControllerClient client, ModelNode op) throws Exception {
        return FrameworkManagement.executeOperation(client, op, true);
    }

    private static ModelNode executeOperation(ModelControllerClient client, ModelNode op, boolean unwrapResult) throws Exception {
        ModelNode ret = client.execute(op);
        if (!unwrapResult) {
            return ret;
        }
        if (!"success".equals(ret.get("outcome").asString())) {
            throw new IllegalStateException("Management operation failed: " + ret.get("failure-description"));
        }
        return ret.get("result");
    }

    static interface ModelDescriptionConstants {
        public static final String ADD = "add";
        public static final String CHILD_TYPE = "child-type";
        public static final String FAILURE_DESCRIPTION = "failure-description";
        public static final String INCLUDE_RUNTIME = "include-runtime";
        public static final String NAME = "name";
        public static final String OUTCOME = "outcome";
        public static final String READ_ATTRIBUTE_OPERATION = "read-attribute";
        public static final String READ_CHILDREN_NAMES_OPERATION = "read-children-names";
        public static final String READ_RESOURCE_OPERATION = "read-resource";
        public static final String RECURSIVE = "recursive";
        public static final String REMOVE = "remove";
        public static final String RESULT = "result";
        public static final String SUCCESS = "success";
        public static final String VALUE = "value";
        public static final String WRITE_ATTRIBUTE_OPERATION = "write-attribute";
    }

    static interface ModelConstants {
        public static final String ACTIVATE = "activate";
        public static final String ACTIVATION = "activation";
        public static final String BUNDLE = "bundle";
        public static final String CAPABILITY = "capability";
        public static final String PROPERTY = "property";
        public static final String START = "start";
        public static final String STARTLEVEL = "startlevel";
        public static final String STATE = "state";
        public static final String STOP = "stop";
        public static final String SYMBOLIC_NAME = "symbolic-name";
        public static final String VALUE = "value";
        public static final String VERSION = "version";
    }
}

