/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.VersionRange;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.util.tracker.ServiceTracker;

public final class FrameworkUtils {
    private FrameworkUtils() {
    }

    public static Bundle[] getBundles(BundleContext context, String symbolicName, VersionRange versionRange) {
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        if ("system.bundle".equals(symbolicName) && versionRange == null) {
            result.add(context.getBundle(0L));
        } else {
            for (Bundle aux : context.getBundles()) {
                if (symbolicName != null && !symbolicName.equals(aux.getSymbolicName()) || versionRange != null && !versionRange.includes(aux.getVersion())) continue;
                result.add(aux);
            }
        }
        return !result.isEmpty() ? result.toArray(new Bundle[result.size()]) : null;
    }

    public static int getFrameworkStartLevel(BundleContext context) {
        return ((FrameworkStartLevel)context.getBundle().adapt(FrameworkStartLevel.class)).getStartLevel();
    }

    public static void setFrameworkStartLevel(BundleContext context, int level) throws InterruptedException, TimeoutException {
        FrameworkUtils.setFrameworkStartLevel(context, level, 10L, TimeUnit.SECONDS);
    }

    public static void setFrameworkStartLevel(BundleContext context, final int level, long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        final FrameworkStartLevel startLevel = (FrameworkStartLevel)context.getBundle().adapt(FrameworkStartLevel.class);
        if (level != startLevel.getStartLevel()) {
            final CountDownLatch latch = new CountDownLatch(1);
            FrameworkListener listener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 8 && level == startLevel.getStartLevel()) {
                        latch.countDown();
                    }
                }
            };
            startLevel.setStartLevel(level, new FrameworkListener[]{listener});
            if (!latch.await(timeout, units)) {
                throw new TimeoutException("Timeout changing start level");
            }
        }
    }

    public static void refreshBundles(BundleContext context, Collection<Bundle> bundles) throws InterruptedException, TimeoutException {
        FrameworkUtils.refreshBundles(context, bundles, 10L, TimeUnit.SECONDS);
    }

    public static void refreshBundles(BundleContext context, Collection<Bundle> bundles, long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        final CountDownLatch latch = new CountDownLatch(1);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4) {
                    latch.countDown();
                }
            }
        };
        FrameworkWiring fwrkWiring = (FrameworkWiring)context.getBundle().adapt(FrameworkWiring.class);
        fwrkWiring.refreshBundles(bundles, new FrameworkListener[]{listener});
        latch.await(10L, TimeUnit.SECONDS);
    }

    public static <T> T waitForService(BundleContext context, Class<T> clazz) {
        return FrameworkUtils.waitForService(context, clazz, 10L, TimeUnit.SECONDS);
    }

    public static <T> T waitForService(BundleContext context, Class<T> clazz, long timeout, TimeUnit unit) {
        final AtomicReference atomicref = new AtomicReference();
        ServiceReferenceHandler handler = new ServiceReferenceHandler<T>(){

            @Override
            public void addingService(ServiceReference<T> sref, T service) {
                atomicref.set(service);
            }
        };
        FrameworkUtils.trackService(context, clazz, handler, timeout, unit);
        Assert.assertNotNull((String)("Service registered: " + clazz.getName()), atomicref.get());
        return (T)atomicref.get();
    }

    public static <T> ServiceReference<T> waitForServiceReference(BundleContext context, Class<T> clazz) {
        return FrameworkUtils.waitForServiceReference(context, clazz, 10L, TimeUnit.SECONDS);
    }

    public static <T> ServiceReference<T> waitForServiceReference(BundleContext context, Class<T> clazz, long timeout, TimeUnit unit) {
        final AtomicReference atomicref = new AtomicReference();
        ServiceReferenceHandler handler = new ServiceReferenceHandler<T>(){

            @Override
            public void addingService(ServiceReference<T> sref, T service) {
                atomicref.set(sref);
            }
        };
        FrameworkUtils.trackService(context, clazz, handler, timeout, unit);
        Assert.assertNotNull((String)("Service registered: " + clazz.getName()), atomicref.get());
        return (ServiceReference)atomicref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void trackService(BundleContext context, Class<T> clazz, final ServiceReferenceHandler<T> handler, long timeout, TimeUnit unit) {
        final CountDownLatch latch = new CountDownLatch(1);
        tracker.open();
        try (ServiceTracker tracker = new ServiceTracker<T, T>(context, clazz.getName(), null){

            public T addingService(ServiceReference<T> sref) {
                Object service = super.addingService(sref);
                handler.addingService(sref, service);
                latch.countDown();
                return service;
            }
        };){
            latch.await(timeout, unit);
        }
    }

    private static interface ServiceReferenceHandler<T> {
        public void addingService(ServiceReference<T> var1, T var2);
    }
}

