/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.osgi.ds.sub.b;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.test.osgi.ds.sub.b1.ServiceB1;
import org.jboss.test.osgi.ds.support.AbstractComponent;
import org.jboss.test.osgi.ds.support.ValidatingReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ServiceB.class}, immediate=true)
public class ServiceB
extends AbstractComponent {
    static AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    final String name = this.getClass().getSimpleName() + "#" + INSTANCE_COUNT.incrementAndGet();
    final ValidatingReference<ServiceB1> ref = new ValidatingReference();

    @Activate
    void activate(ComponentContext context) {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    void bindServiceB1(ServiceB1 service) {
        LOGGER.infof("bindService: %s:%s", (Object)this, (Object)service);
        this.ref.bind(service);
    }

    void unbindServiceB1(ServiceB1 service) {
        LOGGER.infof("unbindService: %s:%s", (Object)this, (Object)service);
        this.ref.unbind(service);
    }

    public ServiceB1 getServiceB1() {
        return this.ref.get();
    }

    public String doStuff(String msg) {
        this.assertValid();
        ServiceB1 srv = this.ref.getOptional();
        return this.name + ":" + (srv != null ? srv.doStuff(msg) : msg);
    }

    public String toString() {
        return this.name;
    }
}

