/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.osgi.ds.sub.c;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.test.osgi.ds.sub.c1.ServiceC1;
import org.jboss.test.osgi.ds.support.AbstractComponent;
import org.jboss.test.osgi.ds.support.ValidatingReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceC.class}, immediate=true)
public class ServiceC
extends AbstractComponent {
    static AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    final String name = this.getClass().getSimpleName() + "#" + INSTANCE_COUNT.incrementAndGet();
    final ValidatingReference<ServiceC1> ref = new ValidatingReference();

    @Activate
    void activate(ComponentContext context) {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Reference
    void bindServiceC1(ServiceC1 service) {
        LOGGER.infof("bindService: %s:%s", (Object)this, (Object)service);
        this.ref.bind(service);
    }

    void unbindServiceC1(ServiceC1 service) {
        LOGGER.infof("unbindService: %s:%s", (Object)this, (Object)service);
        this.ref.unbind(service);
    }

    public ServiceC1 getServiceC1() {
        return this.ref.get();
    }

    public String doStuff(String msg) {
        this.assertValid();
        ServiceC1 srv = this.ref.get();
        return this.name + ":" + srv.doStuff(msg);
    }

    public String toString() {
        return this.name;
    }
}

