/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.osgi.ds.sub.d;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.test.osgi.ds.sub.d1.ServiceD1;
import org.jboss.test.osgi.ds.support.AbstractComponent;
import org.jboss.test.osgi.ds.support.ValidatingReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceD.class}, immediate=true)
public class ServiceD
extends AbstractComponent {
    static AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    final String name = this.getClass().getSimpleName() + "#" + INSTANCE_COUNT.incrementAndGet();
    final ValidatingReference<ServiceD1> ref = new ValidatingReference();
    final CountDownLatch activateLatch = new CountDownLatch(1);
    final CountDownLatch deactivateLatch = new CountDownLatch(1);

    @Activate
    void activate(ComponentContext context) {
        this.activateComponent();
        this.activateLatch.countDown();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.deactivateLatch.countDown();
    }

    public boolean awaitActivate(long timeout, TimeUnit unit) throws InterruptedException {
        return this.activateLatch.await(timeout, unit);
    }

    public boolean awaitDeactivate(long timeout, TimeUnit unit) throws InterruptedException {
        return this.deactivateLatch.await(timeout, unit);
    }

    @Reference
    void bindServiceD1(ServiceD1 service) {
        LOGGER.infof("bindService: %s:%s", (Object)this, (Object)service);
        this.ref.bind(service);
    }

    void unbindServiceD1(ServiceD1 service) {
        LOGGER.infof("unbindService: %s:%s", (Object)this, (Object)service);
        this.ref.unbind(service);
    }

    public ServiceD1 getServiceD1() {
        return this.ref.get();
    }

    public String doStuff(String msg) {
        this.assertValid();
        ServiceD1 srv = this.ref.get();
        return this.name + ":" + srv.doStuff(msg);
    }

    public String toString() {
        return this.name;
    }
}

