/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.osgi.ds.support;

import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.test.osgi.ds.support.Validatable;
import org.jboss.test.osgi.ds.support.ValidationSupport;

public abstract class AbstractComponent
implements Validatable {
    public static final Logger LOGGER = Logger.getLogger(AbstractComponent.class);
    private ValidationSupport active = new ValidationSupport();

    public void activateComponent() {
        LOGGER.infof("activate: %s", (Object)this);
        this.active.setValid();
    }

    public void activateComponent(Map<String, String> config) {
        LOGGER.infof("activate %s with config: %s", (Object)this, config);
        this.active.setValid();
    }

    public void deactivateComponent() {
        LOGGER.infof("deactivate: %s", (Object)this);
        this.active.setInvalid();
    }

    @Override
    public boolean isValid() {
        return this.active.isValid();
    }

    @Override
    public void assertValid() {
        this.active.assertValid();
    }
}

