/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.felix.webconsole.internal.servlet;


import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.Render;
import org.jboss.osgi.webconsole.internal.plugins.PluginHelper;


public class RenderBridge extends AbstractWebConsolePlugin
{

    /** Pseudo class version ID to keep the IDE quite. */
    private static final long serialVersionUID = 1L;

    private final Render render;


    RenderBridge( Render render )
    {
        this.render = render;
    }


    @Override
    protected String getHeader()
    {
       return PluginHelper.getHeader();
    }

    @Override
    protected void endResponse(HttpServletRequest request, PrintWriter pw)
    {
       String appRoot = (String)request.getAttribute(OsgiManager.ATTR_APP_ROOT);
       String footer = MessageFormat.format(PluginHelper.getFooter(), new Object[]{ appRoot });
       pw.println(footer);
    }
    
    public Render getRender()
    {
        return render;
    }


    public String getTitle()
    {
        return render.getLabel();
    }


    public String getLabel()
    {
        return render.getName();
    }


    protected void renderContent( HttpServletRequest request, HttpServletResponse response ) throws ServletException,
        IOException
    {
        render.render( request, response );
    }

}
