/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.webconsole.internal.plugins;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.webconsole.internal.core.BundlesServlet;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentRegistryService;
import org.jboss.osgi.webconsole.internal.plugins.PluginHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class BundlesPlugin
extends BundlesServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected String getHeader() {
        return PluginHelper.getHeader();
    }

    @Override
    protected boolean actionUninstall(Bundle bundle) {
        Version version;
        String symbolicName;
        BundleContext context = this.getBundleContext();
        ServiceReference sref = context.getServiceReference(DeployerService.class.getName());
        if (sref == null) {
            this.getLog().log(2, "Cannot obtain service: " + DeployerService.class.getName());
            return super.actionUninstall(bundle);
        }
        DeployerService service = (DeployerService)context.getService(sref);
        sref = context.getServiceReference(DeploymentRegistryService.class.getName());
        DeploymentRegistryService registry = (DeploymentRegistryService)context.getService(sref);
        Deployment dep = registry.getDeployment(symbolicName = bundle.getSymbolicName(), version = bundle.getVersion());
        if (dep == null) {
            this.getLog().log(2, "Cannot find bundle deployment for: " + bundle);
            return super.actionUninstall(bundle);
        }
        try {
            service.undeploy(new Deployment[]{dep});
            return true;
        }
        catch (BundleException be) {
            this.getLog().log(1, "Cannot uninstall", be);
            return false;
        }
    }

    @Override
    protected void endResponse(HttpServletRequest request, PrintWriter pw) {
    }
}

