/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.jbosgi.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.arquillian.container.osgi.AbstractOSGiApplicationArchiveProcessor;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.as.arquillian.jbosgi.container.ManifestUtils;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;

public class JBOSGiApplicationArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final ArchivePath MANIFEST_PATH = ArchivePaths.create((String)"META-INF/MANIFEST.MF");
    private static final String ESSENTIAL_DEPENDENCIES = "org.jboss.as.osgi,deployment.arquillian-service";

    public void process(Archive<?> appArchive, TestClass testClass) {
        if (JBOSGiApplicationArchiveProcessor.isValidOSGiBundleArchive(appArchive)) {
            AbstractOSGiApplicationArchiveProcessor processor = new AbstractOSGiApplicationArchiveProcessor(){

                protected Manifest createBundleManifest(String symbolicName) {
                    return null;
                }
            };
            processor.process(appArchive, testClass);
        } else {
            try {
                Attributes attrs;
                String dependenciesAttr;
                Manifest existingManifest = new Manifest();
                Node manifestNode = appArchive.get(MANIFEST_PATH);
                if (manifestNode != null) {
                    existingManifest = new Manifest(manifestNode.getAsset().openStream());
                    appArchive.delete(MANIFEST_PATH);
                }
                String string = dependenciesAttr = (attrs = existingManifest.getMainAttributes()) != null ? attrs.getValue("Dependencies") : null;
                if (dependenciesAttr != null) {
                    dependenciesAttr = dependenciesAttr + ",org.jboss.as.osgi,deployment.arquillian-service";
                } else {
                    dependenciesAttr = ESSENTIAL_DEPENDENCIES;
                    attrs.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
                }
                attrs.putValue("Dependencies", dependenciesAttr);
                final Manifest newManifest = existingManifest;
                appArchive.add(new Asset(){

                    public InputStream openStream() {
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            newManifest.write(bos);
                            return new ByteArrayInputStream(bos.toByteArray());
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Unable to write customized application manifest", e);
                        }
                    }
                }, "META-INF/MANIFEST.MF");
            }
            catch (IOException | IllegalArgumentException e) {
                throw new RuntimeException("Unable to customize existing application manifest", e);
            }
        }
    }

    public static boolean isValidOSGiBundleArchive(Archive<?> appArchive) {
        ClassLoader classLoader = JBOSGiApplicationArchiveProcessor.class.getClassLoader();
        try {
            classLoader.loadClass("org.jboss.arquillian.container.osgi.AbstractOSGiApplicationArchiveProcessor");
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        Manifest manifest = ManifestUtils.getManifest(appArchive, true);
        return OSGiManifestBuilder.isValidBundleManifest((Manifest)manifest);
    }
}

