/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.naming;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.naming.BundleContextBindingService;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.osgi.framework.BundleContext;

public class BundleContextBindingProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier ORG_JBOSS_OSGI_RESOLVER = ModuleIdentifier.create((String)"org.jboss.osgi.resolver");
    private static final ModuleIdentifier ORG_OSGI_CORE = ModuleIdentifier.create((String)"org.osgi.core");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CompositeIndex compositeIndex = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            OSGiLogger.LOGGER.warnCannotFindAnnotationIndex(depUnit);
            return;
        }
        boolean hasBundleContextResource = false;
        DotName resourceDotName = DotName.createSimple((String)Resource.class.getName());
        DotName targetDotName = DotName.createSimple((String)BundleContext.class.getName());
        List anList = compositeIndex.getAnnotations(resourceDotName);
        for (AnnotationInstance an : anList) {
            FieldInfo fieldInfo;
            Type targetType;
            AnnotationTarget anTarget = an.target();
            if (!(anTarget instanceof FieldInfo) || !(targetType = (fieldInfo = (FieldInfo)anTarget).type()).name().equals((Object)targetDotName)) continue;
            hasBundleContextResource = true;
            break;
        }
        if (hasBundleContextResource) {
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            ModuleSpecification moduleSpecification = (ModuleSpecification)depUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleDependency coreDep = new ModuleDependency(moduleLoader, ORG_OSGI_CORE, false, false, false, false);
            ModuleDependency resolverDep = new ModuleDependency(moduleLoader, ORG_JBOSS_OSGI_RESOLVER, false, false, false, false);
            moduleSpecification.addSystemDependencies(Arrays.asList(coreDep, resolverDep));
            ServiceName binderServiceName = BundleContextBindingService.getBinderServiceName();
            phaseContext.addDependency(binderServiceName, AttachmentKey.create(ManagedReferenceFactory.class));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

