/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.naming;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Resource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.naming.BundleContextBindingService;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.osgi.framework.BundleContext;

public class BundleContextBindingProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier ORG_JBOSS_OSGI_RESOLVER = ModuleIdentifier.create((String)"org.jboss.osgi.resolver");
    private static final ModuleIdentifier ORG_OSGI_CORE = ModuleIdentifier.create((String)"org.osgi.core");
    private static final DotName RESOURCE_DOT_NAME = DotName.createSimple((String)Resource.class.getName());
    private static final DotName INJECT_DOT_NAME = DotName.createSimple((String)"javax.inject.Inject");
    private static final DotName TARGET_DOT_NAME = DotName.createSimple((String)BundleContext.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CompositeIndex compositeIndex = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            OSGiLogger.LOGGER.warnCannotFindAnnotationIndex(depUnit);
            return;
        }
        boolean hasBundleContextResource = false;
        ArrayList anList = new ArrayList();
        anList.addAll(compositeIndex.getAnnotations(RESOURCE_DOT_NAME));
        anList.addAll(compositeIndex.getAnnotations(INJECT_DOT_NAME));
        for (AnnotationInstance an : anList) {
            MethodParameterInfo methodParamInfo;
            MethodInfo methodInfo;
            Type targetType;
            Type targetType2;
            AnnotationTarget anTarget = an.target();
            if (anTarget instanceof FieldInfo) {
                FieldInfo fieldInfo = (FieldInfo)anTarget;
                targetType2 = fieldInfo.type();
                if (!TARGET_DOT_NAME.equals((Object)targetType2.name())) continue;
                hasBundleContextResource = true;
                break;
            }
            if (anTarget instanceof MethodInfo) {
                MethodInfo methodInfo2 = (MethodInfo)anTarget;
                targetType2 = methodInfo2.args();
                int n = ((Type[])targetType2).length;
                for (int i = 0; i < n; ++i) {
                    Type targetType3 = targetType2[i];
                    if (!TARGET_DOT_NAME.equals((Object)targetType3.name())) continue;
                    hasBundleContextResource = true;
                    break;
                }
                if (TARGET_DOT_NAME.equals((Object)(targetType2 = methodInfo2.returnType()).name())) {
                    hasBundleContextResource = true;
                }
                if (!hasBundleContextResource) continue;
                break;
            }
            if (!(anTarget instanceof MethodParameterInfo) || !TARGET_DOT_NAME.equals((Object)(targetType = (methodInfo = (methodParamInfo = (MethodParameterInfo)anTarget).method()).args()[methodParamInfo.position()]).name())) continue;
            hasBundleContextResource = true;
            break;
        }
        if (hasBundleContextResource) {
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            ModuleSpecification moduleSpecification = (ModuleSpecification)depUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleDependency coreDep = new ModuleDependency(moduleLoader, ORG_OSGI_CORE, false, false, false, false);
            ModuleDependency resolverDep = new ModuleDependency(moduleLoader, ORG_JBOSS_OSGI_RESOLVER, false, false, false, false);
            moduleSpecification.addSystemDependencies(Arrays.asList(coreDep, resolverDep));
            ServiceName binderServiceName = BundleContextBindingService.getBinderServiceName();
            phaseContext.addDependency(binderServiceName, AttachmentKey.create(ManagedReferenceFactory.class));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

