/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.service.resolver.ResolutionException;

public class BundleResolveProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Deployment deployment = (Deployment)depUnit.getAttachment(OSGiConstants.DEPLOYMENT_KEY);
        XBundleRevision brev = (XBundleRevision)depUnit.getAttachment(OSGiConstants.BUNDLE_REVISION_KEY);
        if (brev == null || !deployment.isAutoStart() || brev.getBundle().isResolved()) {
            return;
        }
        this.resolveBundle(phaseContext, depUnit, brev.getBundle());
    }

    private void resolveBundle(DeploymentPhaseContext phaseContext, DeploymentUnit depUnit, XBundle bundle2) {
        XBundleRevision brev = bundle2.getBundleRevision();
        XEnvironment env = (XEnvironment)depUnit.getAttachment(OSGiConstants.ENVIRONMENT_KEY);
        XResolver resolver = (XResolver)depUnit.getAttachment(OSGiConstants.RESOLVER_KEY);
        BundleManager bundleManager = (BundleManager)depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
        Set<XBundleRevision> mandatoryResources = Collections.singleton(brev);
        Set<XBundleRevision> optionalResources = this.getOptionalResources(bundleManager, brev);
        XResolveContext context = resolver.createResolveContext(env, mandatoryResources, optionalResources);
        try {
            OSGiLogger.LOGGER.debugf("Resolve: %s", depUnit.getName());
            resolver.resolveAndApply(context);
            depUnit.putAttachment(Attachments.BUNDLE_STATE_KEY, (Object)Attachments.BundleState.RESOLVED);
        }
        catch (ResolutionException ex) {
            OSGiLogger.LOGGER.warnCannotResolve(ex.getUnresolvedRequirements());
        }
    }

    private Set<XBundleRevision> getOptionalResources(BundleManager bundleManager, XBundleRevision brev) {
        HashSet<XBundleRevision> result = null;
        for (BundleRequirement req : brev.getDeclaredRequirements("osgi.wiring.package")) {
            XPackageRequirement preq = (XPackageRequirement)req;
            if (!preq.isOptional()) continue;
            result = new HashSet<XBundleRevision>();
            for (XBundle bundle2 : bundleManager.getBundles(Integer.valueOf(2))) {
                result.add(bundle2.getBundleRevision());
            }
        }
        return result;
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

