/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.jar.Manifest;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.service.BundleLifecycleIntegration;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;

public class OSGiMetaDataStructureProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        OSGiMetaData metadata = (OSGiMetaData)depUnit.getAttachment(OSGiConstants.OSGI_METADATA_KEY);
        Deployment dep = BundleLifecycleIntegration.getDeployment(depUnit.getName());
        if (metadata == null && dep != null) {
            metadata = (OSGiMetaData)dep.getAttachment(IntegrationConstants.OSGI_METADATA_KEY);
        }
        Manifest manifest = (Manifest)depUnit.getAttachment(Attachments.OSGI_MANIFEST);
        if (metadata == null && manifest != null) {
            metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
        }
        if (metadata != null) {
            depUnit.putAttachment(OSGiConstants.OSGI_METADATA_KEY, (Object)metadata);
            phaseContext.addDependency(FrameworkBootstrapService.SERVICE_NAME, AttachmentKey.create(Void.class));
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(OSGiConstants.OSGI_METADATA_KEY);
    }
}

