/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.LayeredBundlePathFactory;
import org.jboss.as.osgi.service.ModuleIdentityRepositoryIntegration;
import org.jboss.as.osgi.service.ResourceInstallerService;
import org.jboss.as.osgi.service.SystemPackagesIntegration;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.BootstrapBundlesActivate;
import org.jboss.osgi.framework.spi.BootstrapBundlesInstall;
import org.jboss.osgi.framework.spi.BootstrapBundlesResolve;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StorageManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.repository.ResourceInstaller;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.spi.MavenIdentityRepository;
import org.jboss.osgi.resolver.MavenCoordinates;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XRequirementBuilder;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

class BootstrapBundlesIntegration
extends BootstrapBundlesInstall<Void> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<StorageManager> injectedStorageManager = new InjectedValue();
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XRepository> injectedRepository = new InjectedValue();
    private final InjectedValue<ResourceInstaller> injectedResourceInstaller = new InjectedValue();
    private List<SubsystemState.OSGiCapability> modulecaps;
    private List<File> bundlesPath;

    BootstrapBundlesIntegration() {
        super(IntegrationServices.BOOTSTRAP_BUNDLES);
    }

    protected void addServiceDependencies(ServiceBuilder<Void> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(OSGiConstants.SUBSYSTEM_STATE_SERVICE_NAME, SubsystemState.class, this.injectedSubsystemState);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.injectedServerEnvironment);
        builder.addDependency(ResourceInstallerService.SERVICE_NAME, ResourceInstaller.class, this.injectedResourceInstaller);
        builder.addDependency(OSGiConstants.REPOSITORY_SERVICE_NAME, XRepository.class, this.injectedRepository);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(IntegrationServices.STORAGE_MANAGER_PLUGIN, StorageManager.class, this.injectedStorageManager);
    }

    public synchronized void start(StartContext context) throws StartException {
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        ServerEnvironment serverEnvironment = (ServerEnvironment)this.injectedServerEnvironment.getValue();
        this.bundlesPath = LayeredBundlePathFactory.resolveLayeredBundlePath(serverEnvironment);
        this.modulecaps = new ArrayList<SubsystemState.OSGiCapability>();
        ArrayList<SubsystemState.OSGiCapability> configcaps = new ArrayList<SubsystemState.OSGiCapability>();
        for (String capspec : SystemPackagesIntegration.DEFAULT_CAPABILITIES) {
            configcaps.add(new SubsystemState.OSGiCapability(capspec, null));
        }
        configcaps.addAll(((SubsystemState)this.injectedSubsystemState.getValue()).getCapabilities());
        Iterator iterator = configcaps.iterator();
        while (iterator.hasNext()) {
            SubsystemState.OSGiCapability configcap = (SubsystemState.OSGiCapability)iterator.next();
            String identifier = configcap.getIdentifier();
            if (!this.isValidModuleIdentifier(identifier)) continue;
            try {
                XBundle bundle2 = this.installInitialModuleCapability(configcap);
                if (bundle2 == null) continue;
                this.modulecaps.add(configcap);
                iterator.remove();
            }
            catch (Exception ex) {
                throw OSGiMessages.MESSAGES.startFailedToProcessInitialCapability(ex, identifier);
            }
        }
        for (SubsystemState.OSGiCapability configcap : configcaps) {
            String identifier = configcap.getIdentifier();
            try {
                Deployment dep = this.getInitialBundleDeployment(configcap);
                deployments.add(dep);
            }
            catch (Exception ex) {
                throw OSGiMessages.MESSAGES.startFailedToProcessInitialCapability(ex, identifier);
            }
        }
        this.installBootstrapBundles(context.getChildTarget(), deployments);
    }

    protected ServiceController<Void> installResolveService(ServiceTarget serviceTarget, Set<XBundleRevision> installedRevisions) {
        return new BootstrapResolveIntegration(this.getServiceName().getParent(), installedRevisions).install(serviceTarget, this.getServiceListener());
    }

    private XBundle installInitialModuleCapability(SubsystemState.OSGiCapability configcap) throws Exception {
        String identifier = configcap.getIdentifier();
        ModuleIdentifier moduleId = ModuleIdentifier.fromString((String)identifier);
        ModuleIdentityRepositoryIntegration repository = this.getModuleIdentityRepository();
        File bundleFile = repository.getRepositoryEntry(this.bundlesPath, moduleId);
        if (bundleFile != null) {
            return null;
        }
        OSGiLogger.LOGGER.tracef("Installing initial module capability: %s", identifier);
        XRequirementBuilder reqbuilder = XRequirementBuilder.create((ModuleIdentifier)moduleId);
        XRequirement modreq = reqbuilder.getRequirement();
        Collection<Capability> caps = repository.findProviders((Requirement)modreq);
        if (caps.isEmpty()) {
            throw OSGiMessages.MESSAGES.cannotResolveInitialCapability(null, identifier);
        }
        XCapability icap = (XCapability)caps.iterator().next();
        XResource resource = icap.getResource();
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        ResourceInstaller installer = (ResourceInstaller)this.injectedResourceInstaller.getValue();
        XBundle bundle2 = installer.installModuleResource(syscontext, resource);
        Integer startlevel = configcap.getStartLevel();
        if (startlevel != null && startlevel > 0) {
            BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle2.adapt(BundleStartLevel.class);
            bundleStartLevel.setStartLevel(startlevel.intValue());
        }
        return bundle2;
    }

    private Deployment getInitialBundleDeployment(SubsystemState.OSGiCapability configcap) throws Exception {
        String identifier = configcap.getIdentifier();
        Integer level = configcap.getStartLevel();
        Deployment deployment = null;
        if (this.isValidModuleIdentifier(identifier)) {
            ModuleIdentifier moduleId = ModuleIdentifier.fromString((String)identifier);
            File bundleFile = this.getModuleIdentityRepository().getRepositoryEntry(this.bundlesPath, moduleId);
            if (bundleFile != null) {
                OSGiLogger.LOGGER.tracef("Installing initial bundle capability: %s", identifier);
                URL bundleURL = bundleFile.toURI().toURL();
                deployment = this.getDeploymentFromURL(bundleURL, identifier, level);
            }
        } else if (this.isValidMavenIdentifier(identifier)) {
            OSGiLogger.LOGGER.tracef("Installing initial maven capability: %s", identifier);
            MavenCoordinates mavenId = MavenCoordinates.parse((String)identifier);
            XRequirement req = XRequirementBuilder.create((MavenCoordinates)mavenId).getRequirement();
            Collection caps = this.getMavenIdentityRepository().findProviders((Requirement)req);
            if (!caps.isEmpty()) {
                XResource resource = (XResource)((Capability)caps.iterator().next()).getResource();
                XCapability ccap = (XCapability)resource.getCapabilities("osgi.content").get(0);
                URL bundleURL = new URL((String)ccap.getAttribute("url"));
                deployment = this.getDeploymentFromURL(bundleURL, identifier, level);
            }
        }
        if (deployment == null) {
            throw OSGiMessages.MESSAGES.cannotResolveInitialCapability(null, identifier);
        }
        return deployment;
    }

    private ModuleIdentityRepositoryIntegration getModuleIdentityRepository() {
        XRepository repository = (XRepository)this.injectedRepository.getValue();
        return (ModuleIdentityRepositoryIntegration)((Object)repository.adapt(ModuleIdentityRepositoryIntegration.class));
    }

    private MavenIdentityRepository getMavenIdentityRepository() {
        XRepository repository = (XRepository)this.injectedRepository.getValue();
        return (MavenIdentityRepository)repository.adapt(MavenIdentityRepository.class);
    }

    private boolean isValidModuleIdentifier(String identifier) {
        try {
            ModuleIdentifier.fromString((String)identifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isValidMavenIdentifier(String identifier) {
        try {
            MavenCoordinates.parse((String)identifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Deployment getDeploymentFromURL(URL bundleURL, String location, Integer level) throws Exception {
        int startlevel;
        BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)AbstractVFS.toVirtualFile((URL)bundleURL), (String)location);
        Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
        int n = startlevel = level != null ? level : 0;
        if (startlevel > 0) {
            dep.setStartLevel(Integer.valueOf(level));
            dep.setAutoStart(true);
        }
        StorageManager storageManager = (StorageManager)this.injectedStorageManager.getValue();
        Long bundleId = ((XEnvironment)this.injectedEnvironment.getValue()).nextResourceIdentifier(null, dep.getSymbolicName());
        StorageState storageState = storageManager.createStorageState(bundleId.longValue(), location, Integer.valueOf(startlevel), null);
        dep.putAttachment(IntegrationConstants.STORAGE_STATE_KEY, (Object)storageState);
        return dep;
    }

    class BootstrapActivateIntegration
    extends BootstrapBundlesActivate<Void> {
        BootstrapActivateIntegration(ServiceName baseName, Set<XBundle> resolvedBundles) {
            super(baseName, resolvedBundles);
        }

        public void start(StartContext context) throws StartException {
            BundleManager bundleManager = (BundleManager)BootstrapBundlesIntegration.this.injectedBundleManager.getValue();
            for (SubsystemState.OSGiCapability modcap : BootstrapBundlesIntegration.this.modulecaps) {
                if (modcap.getStartLevel() == null) continue;
                String identifier = modcap.getIdentifier();
                XBundle bundle2 = bundleManager.getBundleByLocation(identifier);
                try {
                    bundle2.start(2);
                }
                catch (BundleException ex) {
                    OSGiLogger.LOGGER.errorCannotStartBundle(ex, (Bundle)bundle2);
                }
            }
            super.start(context);
        }
    }

    class BootstrapResolveIntegration
    extends BootstrapBundlesResolve<Void> {
        BootstrapResolveIntegration(ServiceName baseName, Set<XBundleRevision> installedRevisions) {
            super(baseName, installedRevisions);
        }

        protected ServiceController<Void> installActivateService(ServiceTarget serviceTarget, Set<XBundle> resolvedBundles) {
            return new BootstrapActivateIntegration(this.getServiceName().getParent(), resolvedBundles).install(serviceTarget, this.getServiceListener());
        }
    }
}

