/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.FrameworkBuilder;

public final class FrameworkActivator {
    private static FrameworkActivator INSTANCE;
    private final AtomicBoolean activated;
    private final FrameworkBuilder builder;

    public static void create(FrameworkBuilder builder) {
        INSTANCE = new FrameworkActivator(builder);
    }

    public static boolean activate(ServiceVerificationHandler verificationHandler) {
        return INSTANCE.activateInternal(SubsystemState.Activation.LAZY, verificationHandler);
    }

    public static boolean activateEagerly(ServiceVerificationHandler verificationHandler) {
        return INSTANCE.activateInternal(SubsystemState.Activation.EAGER, verificationHandler);
    }

    private FrameworkActivator(FrameworkBuilder builder) {
        this.activated = new AtomicBoolean(builder.getInitialMode() == ServiceController.Mode.ACTIVE);
        this.builder = builder;
    }

    private boolean activateInternal(SubsystemState.Activation activation, ServiceVerificationHandler verificationHandler) {
        boolean activate = this.activated.compareAndSet(false, true);
        if (activate) {
            OSGiLogger.LOGGER.debugf("Activating %sly", (Object)activation);
            ServiceTarget serviceTarget = this.builder.getServiceTarget();
            this.builder.installServices(FrameworkBuilder.FrameworkPhase.INIT, serviceTarget, (ServiceListener)verificationHandler);
            this.builder.installServices(FrameworkBuilder.FrameworkPhase.ACTIVE, serviceTarget, (ServiceListener)verificationHandler);
            ServiceName serviceName = Services.FRAMEWORK_ACTIVE.getParent().append(new String[]{activation.toString(), "ACTIVATOR"});
            switch (activation) {
                case EAGER: {
                    EagerActivatorService.addService(serviceTarget, serviceName, verificationHandler);
                    break;
                }
                case LAZY: {
                    LazyActivatorService.addService(serviceTarget, serviceName, verificationHandler);
                }
            }
        }
        return activate;
    }

    static class LazyActivatorService
    extends AbstractService<Void> {
        LazyActivatorService() {
        }

        static void addService(ServiceTarget serviceTarget, ServiceName serviceName, ServiceVerificationHandler verificationHandler) {
            ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)new LazyActivatorService());
            builder.addDependency(FrameworkBootstrapService.SERVICE_NAME);
            builder.addListener((ServiceListener)verificationHandler);
            builder.install();
        }

        public void start(StartContext context) throws StartException {
            ServiceContainer serviceContainer = context.getController().getServiceContainer();
            serviceContainer.getRequiredService(Services.FRAMEWORK_ACTIVE).setMode(ServiceController.Mode.ACTIVE);
        }
    }

    static class EagerActivatorService
    extends AbstractService<Void> {
        EagerActivatorService() {
        }

        static void addService(ServiceTarget serviceTarget, ServiceName serviceName, ServiceVerificationHandler verificationHandler) {
            ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)new EagerActivatorService());
            builder.addDependency(Services.FRAMEWORK_ACTIVE);
            builder.addListener((ServiceListener)verificationHandler);
            builder.install();
        }
    }
}

