/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentHelper;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.deployment.BundleDeploymentProcessor;
import org.jboss.as.osgi.management.OperationAssociation;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.spi.BundleLifecycle;
import org.jboss.osgi.framework.spi.BundleLifecyclePlugin;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.DeploymentProvider;
import org.jboss.osgi.framework.spi.FutureServiceValue;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.StorageManager;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.spi.AttachmentKey;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.service.resolver.ResolutionException;

public final class BundleLifecycleIntegration
extends BundleLifecyclePlugin {
    private static final AttachmentKey<String> RUNTIME_NAME_KEY = AttachmentKey.create(String.class);
    private static final AttachmentKey<Boolean> BUNDLE_REFRESHING_KEY = AttachmentKey.create(Boolean.class);
    private static final Map<String, Deployment> deploymentMap = new HashMap<String, Deployment>();
    private final InjectedValue<ModelController> injectedController = new InjectedValue();
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private final InjectedValue<StorageManager> injectedStorageManager = new InjectedValue();
    private final InjectedValue<DeploymentProvider> injectedDeploymentManager = new InjectedValue();
    private final InjectedValue<LockManager> injectedLockManager = new InjectedValue();
    private ServerDeploymentManager serverDeploymentManager;
    private ModelControllerClient modelControllerClient;

    protected void addServiceDependencies(ServiceBuilder<BundleLifecycle> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, this.injectedController);
        builder.addDependency(IntegrationServices.STORAGE_MANAGER_PLUGIN, StorageManager.class, this.injectedStorageManager);
        builder.addDependency(IntegrationServices.DEPLOYMENT_PROVIDER_PLUGIN, DeploymentProvider.class, this.injectedDeploymentManager);
        builder.addDependency(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class, this.injectedLockManager);
        builder.addDependency(org.jboss.osgi.framework.Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(org.jboss.osgi.framework.Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(org.jboss.osgi.framework.Services.RESOLVER, XResolver.class, this.injectedResolver);
        builder.addDependency(org.jboss.osgi.framework.Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext startContext) throws StartException {
        super.start(startContext);
        ModelController modelController = (ModelController)this.injectedController.getValue();
        this.modelControllerClient = modelController.createClient((Executor)Executors.newCachedThreadPool());
        this.serverDeploymentManager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.modelControllerClient);
    }

    public void stop(StopContext context) {
        try {
            this.modelControllerClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.stop(context);
    }

    protected BundleLifecycle createServiceValue(StartContext startContext) throws StartException {
        return new BundleLifecycleImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Deployment getDeployment(String runtimeName) {
        Map<String, Deployment> map = deploymentMap;
        synchronized (map) {
            return deploymentMap.get(runtimeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Deployment removeDeployment(String runtimeName) {
        Map<String, Deployment> map = deploymentMap;
        synchronized (map) {
            return deploymentMap.remove(runtimeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDeployment(String runtimeName, Deployment dep) {
        Map<String, Deployment> map = deploymentMap;
        synchronized (map) {
            deploymentMap.put(runtimeName, dep);
        }
    }

    public static boolean isBundleRefreshing(XBundle bundle2) {
        return Boolean.TRUE.equals(bundle2.getAttachment(BUNDLE_REFRESHING_KEY));
    }

    class BundleLifecycleImpl
    implements BundleLifecycle {
        private final BundleManager bundleManager;
        private final XEnvironment environment;
        private final XResolver resolver;

        BundleLifecycleImpl() {
            this.bundleManager = (BundleManager)BundleLifecycleIntegration.this.injectedBundleManager.getValue();
            this.environment = (XEnvironment)BundleLifecycleIntegration.this.injectedEnvironment.getValue();
            this.resolver = (XResolver)BundleLifecycleIntegration.this.injectedResolver.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XBundleRevision createBundleRevision(BundleContext context, Deployment deployment) throws BundleException {
            if (OperationAssociation.INSTANCE.getAssociation() != null) {
                OSGiLogger.LOGGER.warnCannotDeployBundleFromManagementOperation(deployment);
                return this.bundleManager.installBundleRevision(context, deployment, null);
            }
            if (!deployment.isBundleUpdate() && this.bundleManager.getBundleByLocation(deployment.getLocation()) != null) {
                return this.bundleManager.installBundleRevision(context, deployment, null);
            }
            OSGiLogger.LOGGER.debugf("Install deployment: %s", deployment);
            String runtimeName = this.getRuntimeName(deployment);
            BundleLifecycleIntegration.this.putDeployment(runtimeName, deployment);
            try {
                InputStream input = deployment.getRoot().openStream();
                try {
                    ServerDeploymentHelper server = new ServerDeploymentHelper(BundleLifecycleIntegration.this.serverDeploymentManager);
                    server.deploy(runtimeName, input);
                }
                finally {
                    VFSUtils.safeClose((Closeable)input);
                }
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw OSGiMessages.MESSAGES.cannotDeployBundleRevision(ex, deployment);
            }
            DeploymentUnit depUnit = (DeploymentUnit)deployment.getAttachment(BundleDeploymentProcessor.DEPLOYMENT_UNIT_KEY);
            XBundleRevision brev = (XBundleRevision)depUnit.getAttachment(OSGiConstants.BUNDLE_REVISION_KEY);
            return brev;
        }

        public void resolve(XBundle bundle2) throws ResolutionException {
            this.bundleManager.resolveBundle(bundle2);
            Deployment deployment = (Deployment)bundle2.adapt(Deployment.class);
            DeploymentUnit depUnit = (DeploymentUnit)deployment.getAttachment(BundleDeploymentProcessor.DEPLOYMENT_UNIT_KEY);
            if (depUnit == null) {
                ModuleIdentifier identifier = bundle2.getBundleRevision().getModuleIdentifier();
                ServiceName moduleServiceName = ServiceModuleLoader.moduleServiceName((ModuleIdentifier)identifier);
                ServiceContainer serviceRegistry = this.bundleManager.getServiceContainer();
                ServiceController controller = serviceRegistry.getRequiredService(moduleServiceName);
                FutureServiceValue future = new FutureServiceValue(controller);
                try {
                    future.get(2L, TimeUnit.SECONDS);
                }
                catch (Exception ex) {
                    throw FrameworkMessages.MESSAGES.illegalStateCannotLoadModule((Throwable)ex, identifier);
                }
            }
        }

        public void start(XBundle bundle2, int options) throws BundleException {
            Deployment deployment = (Deployment)bundle2.adapt(Deployment.class);
            DeploymentUnit depUnit = (DeploymentUnit)deployment.getAttachment(BundleDeploymentProcessor.DEPLOYMENT_UNIT_KEY);
            if (depUnit == null) {
                this.bundleManager.startBundle(bundle2, options);
                return;
            }
            List deferredModules = DeploymentUtils.getDeferredModules((DeploymentUnit)depUnit);
            if (!deferredModules.contains(depUnit.getName())) {
                this.bundleManager.startBundle(bundle2, options);
                return;
            }
            ServiceController<Phase> phaseService = this.getDeferredPhaseService(depUnit);
            if (phaseService.getMode() != ServiceController.Mode.NEVER) {
                this.bundleManager.startBundle(bundle2, options);
                return;
            }
            ServiceName deploymentServiceName = depUnit.getParent() == null ? depUnit.getServiceName() : depUnit.getParent().getServiceName();
            ServiceContainer serviceContainer = this.bundleManager.getServiceContainer();
            ServiceController deploymentService = serviceContainer.getRequiredService(deploymentServiceName);
            this.activateDeferredPhase(bundle2, options, depUnit, phaseService, (ServiceController<DeploymentUnit>)deploymentService);
        }

        public void stop(XBundle bundle2, int options) throws BundleException {
            this.bundleManager.stopBundle(bundle2, options);
        }

        public void removeRevision(XBundleRevision brev, int options) {
            this.undeployRevision(brev);
            if (brev.getState() != XResource.State.UNINSTALLED) {
                this.bundleManager.removeRevision(brev, options);
            }
        }

        private void undeployRevision(XBundleRevision brev) {
            ServerDeploymentHelper server = new ServerDeploymentHelper(BundleLifecycleIntegration.this.serverDeploymentManager);
            try {
                Deployment deployment = (Deployment)brev.getAttachment(IntegrationConstants.DEPLOYMENT_KEY);
                server.undeploy(this.getRuntimeName(deployment));
            }
            catch (Exception ex) {
                OSGiLogger.LOGGER.warnCannotUndeployBundleRevision(ex, (BundleRevision)brev);
            }
        }

        public BundleLifecycle.BundleRefreshPolicy getBundleRefreshPolicy() {
            return new RecreateCurrentRevisionPolicy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activateDeferredPhase(XBundle bundle2, int options, DeploymentUnit depUnit, ServiceController<Phase> phaseService, ServiceController<DeploymentUnit> parentDeploymentService) throws BundleException {
            FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this.bundleManager.getSystemBundle().adapt(FrameworkStartLevel.class);
            BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle2.adapt(BundleStartLevel.class);
            int startlevel = bundleStartLevel.getStartLevel();
            if (startlevel > frameworkStartLevel.getStartLevel()) {
                OSGiLogger.LOGGER.debugf("Start level [%d] not valid for: %s", startlevel, bundle2);
                return;
            }
            OSGiLogger.LOGGER.infoActivateDeferredModulePhase((Bundle)bundle2);
            if (!bundle2.isResolved()) {
                XResolveContext context = this.resolver.createResolveContext(this.environment, Collections.singleton(bundle2.getBundleRevision()), null);
                try {
                    this.resolver.resolveAndApply(context);
                }
                catch (ResolutionException ex) {
                    throw new BundleException(FrameworkMessages.MESSAGES.cannotResolveBundle((Bundle)bundle2), 4, (Throwable)ex);
                }
            }
            ((AtomicInteger)depUnit.getAttachment(Attachments.DEFERRED_ACTIVATION_COUNT)).incrementAndGet();
            StabilityMonitor monitor = new StabilityMonitor();
            monitor.addController(parentDeploymentService);
            monitor.addController(phaseService);
            HashSet failed = new HashSet();
            HashSet problems = new HashSet();
            try {
                phaseService.setMode(ServiceController.Mode.ACTIVE);
                monitor.awaitStability(failed, problems);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                monitor.clear();
            }
            if (failed.size() > 0 || problems.size() > 0) {
                ArrayList combined = new ArrayList();
                combined.addAll(failed);
                combined.addAll(problems);
                StartException startex = null;
                for (ServiceController aux : combined) {
                    if (aux.getStartException() == null) continue;
                    startex = aux.getStartException();
                    break;
                }
                BundleException failure = startex != null && startex.getCause() instanceof BundleException ? (BundleException)startex.getCause() : OSGiMessages.MESSAGES.cannotActivateDeferredModulePhase((Throwable)startex, (Bundle)bundle2);
                depUnit.putAttachment(OSGiConstants.DEFERRED_ACTIVATION_FAILED, (Object)Boolean.TRUE);
                OSGiLogger.LOGGER.warnDeactivateDeferredModulePhase((Bundle)bundle2);
                phaseService.setMode(ServiceController.Mode.NEVER);
                try {
                    FutureServiceValue future = new FutureServiceValue(phaseService, ServiceController.State.DOWN);
                    future.get(30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException ex) {
                    OSGiLogger.LOGGER.errorf(failure, failure.getMessage(), new Object[0]);
                    throw OSGiMessages.MESSAGES.cannotDeactivateDeferredModulePhase(ex, (Bundle)bundle2);
                }
                catch (TimeoutException ex) {
                    OSGiLogger.LOGGER.errorf(failure, failure.getMessage(), new Object[0]);
                    throw OSGiMessages.MESSAGES.cannotDeactivateDeferredModulePhase(ex, (Bundle)bundle2);
                }
                throw failure;
            }
        }

        private String getRuntimeName(Deployment deployment) {
            String runtimeName = (String)deployment.getAttachment(RUNTIME_NAME_KEY);
            if (runtimeName == null) {
                runtimeName = deployment.getLocation();
                try {
                    new URI(runtimeName);
                    int queryIndex = runtimeName.indexOf(63);
                    if (queryIndex > 0) {
                        runtimeName = runtimeName.substring(0, queryIndex);
                    }
                }
                catch (URISyntaxException queryIndex) {
                    // empty catch block
                }
                if (deployment.isBundleUpdate()) {
                    String suffix = "";
                    XBundle bundle2 = (XBundle)deployment.getAttachment(IntegrationConstants.BUNDLE_KEY);
                    BundleRevisions brevs = (BundleRevisions)bundle2.adapt(BundleRevisions.class);
                    int revid = brevs.getRevisions().size();
                    int dotindex = runtimeName.length() - 4;
                    if (dotindex > 0 && runtimeName.charAt(dotindex) == '.') {
                        suffix = runtimeName.substring(runtimeName.length() - 4);
                        runtimeName = runtimeName.substring(0, dotindex);
                    }
                    runtimeName = runtimeName + "-rev" + revid + suffix;
                }
                deployment.putAttachment(RUNTIME_NAME_KEY, (Object)runtimeName);
            }
            return runtimeName;
        }

        private ServiceController<Phase> getDeferredPhaseService(DeploymentUnit depUnit) {
            ServiceName serviceName = DeploymentUtils.getDeploymentUnitPhaseServiceName((DeploymentUnit)depUnit, (Phase)Phase.FIRST_MODULE_USE);
            ServiceContainer serviceContainer = this.bundleManager.getServiceContainer();
            return serviceContainer.getRequiredService(serviceName);
        }

        private final class RecreateCurrentRevisionPolicy
        implements BundleLifecycle.BundleRefreshPolicy {
            private XBundle bundle;
            private VirtualFile rootFile;

            private RecreateCurrentRevisionPolicy() {
            }

            public void startBundleRefresh(XBundle bundle2) throws BundleException {
                this.bundle = bundle2;
                XBundleRevision brev = bundle2.getBundleRevision();
                Deployment deployment = (Deployment)bundle2.adapt(Deployment.class);
                try {
                    InputStream inputStream = deployment.getRoot().getStreamURL().openStream();
                    this.rootFile = AbstractVFS.toVirtualFile((InputStream)inputStream);
                }
                catch (IOException ex) {
                    throw FrameworkMessages.MESSAGES.cannotObtainVirtualFile((Throwable)ex);
                }
                bundle2.putAttachment(BUNDLE_REFRESHING_KEY, (Object)Boolean.TRUE);
                BundleLifecycleImpl.this.undeployRevision(brev);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void refreshCurrentRevision(XBundleRevision brev) throws BundleException {
                DeploymentProvider deploymentManager = (DeploymentProvider)BundleLifecycleIntegration.this.injectedDeploymentManager.getValue();
                Deployment deployment = deploymentManager.createDeployment(this.bundle.getLocation(), this.rootFile);
                deployment.putAttachment(IntegrationConstants.BUNDLE_KEY, (Object)this.bundle);
                deployment.setAutoStart(false);
                String runtimeName = BundleLifecycleImpl.this.getRuntimeName(deployment);
                BundleLifecycleIntegration.this.putDeployment(runtimeName, deployment);
                try {
                    InputStream input = deployment.getRoot().openStream();
                    try {
                        ServerDeploymentHelper server = new ServerDeploymentHelper(BundleLifecycleIntegration.this.serverDeploymentManager);
                        server.deploy(runtimeName, input);
                    }
                    finally {
                        VFSUtils.safeClose((Closeable)input);
                    }
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Exception ex) {
                    throw OSGiMessages.MESSAGES.cannotDeployBundleRevision(ex, deployment);
                }
            }

            public void endBundleRefresh(XBundle bundle2) {
                bundle2.removeAttachment(BUNDLE_REFRESHING_KEY);
            }
        }
    }
}

