/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.service.BundleLifecycleIntegration;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.JPADeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.spi.AttachmentKey;
import org.jboss.osgi.spi.BundleInfo;

public class BundleDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<DeploymentUnit> DEPLOYMENT_UNIT_KEY = AttachmentKey.create(DeploymentUnit.class);
    public static final AttachmentKey<ModuleSpecification> MODULE_SPECIFICATION_KEY = AttachmentKey.create(ModuleSpecification.class);
    public final String[] EXCLUDED_SUBSYSTEMS = new String[]{"batch", "batch-jberet"};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        String runtimeName = depUnit.getName();
        Deployment deployment = BundleLifecycleIntegration.removeDeployment(runtimeName);
        if (deployment != null) {
            deployment.setAutoStart(false);
        }
        BundleInfo info = (BundleInfo)depUnit.getAttachment(OSGiConstants.BUNDLE_INFO_KEY);
        if (deployment == null && info != null) {
            AnnotationInstance marker;
            deployment = DeploymentFactory.createDeployment((BundleInfo)info);
            deployment.putAttachment(IntegrationConstants.BUNDLE_INFO_KEY, (Object)info);
            OSGiMetaData metadata = info.getOSGiMetadata();
            deployment.setAutoStart(!metadata.isFragment());
            AnnotationInstance slAware = this.getAnnotation(depUnit, "org.jboss.arquillian.osgi.StartLevelAware");
            if (slAware != null) {
                MethodInfo slTarget = (MethodInfo)slAware.target();
                for (AnnotationInstance anDeployment : this.getAnnotations(depUnit, "org.jboss.arquillian.container.test.api.Deployment")) {
                    Object deploymentName;
                    AnnotationValue namevalue = anDeployment.value("name");
                    Object object = deploymentName = namevalue != null ? namevalue.value() : null;
                    if (slTarget != anDeployment.target() || !depUnit.getName().equals(deploymentName)) continue;
                    int startLevel = slAware.value("startLevel").asInt();
                    deployment.setStartLevel(Integer.valueOf(startLevel));
                    deployment.setAutoStart(false);
                }
            }
            if ((marker = this.getAnnotation(depUnit, "org.jboss.as.arquillian.jbosgi.api.DeploymentMarker")) != null) {
                AnnotationValue value = marker.value("autoStart");
                if (value != null && deployment.isAutoStart()) {
                    deployment.setAutoStart(value.asBoolean());
                }
                if ((value = marker.value("startLevel")) != null && deployment.getStartLevel() == null) {
                    deployment.setStartLevel(Integer.valueOf(value.asInt()));
                }
            }
        }
        if (deployment != null) {
            ModuleSpecification moduleSpec;
            ModuleIdentifier identifier = (ModuleIdentifier)depUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
            deployment.putAttachment(IntegrationConstants.MODULE_IDENTIFIER_KEY, (Object)identifier);
            if (this.allowAdditionalModuleDependencies(depUnit)) {
                moduleSpec = (ModuleSpecification)depUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
                deployment.putAttachment(MODULE_SPECIFICATION_KEY, (Object)moduleSpec);
            } else {
                moduleSpec = (ModuleSpecification)depUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
                moduleSpec.setPrivateModule(true);
            }
            depUnit.putAttachment(OSGiConstants.DEPLOYMENT_KEY, (Object)deployment);
            deployment.putAttachment(DEPLOYMENT_UNIT_KEY, (Object)depUnit);
            DeploymentUnit parent = depUnit.getParent() == null ? depUnit : depUnit.getParent();
            boolean noExistingSubsystems = false;
            HashSet<String> excludedSubsystems = (HashSet<String>)depUnit.getAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
            if (excludedSubsystems == null) {
                excludedSubsystems = new HashSet<String>();
                noExistingSubsystems = true;
            }
            excludedSubsystems.addAll(Arrays.asList(this.EXCLUDED_SUBSYSTEMS));
            if (noExistingSubsystems) {
                depUnit.putAttachment(Attachments.EXCLUDED_SUBSYSTEMS, excludedSubsystems);
            }
            parent.putAttachment(Attachments.ALLOW_PHASE_RESTART, (Object)true);
        }
    }

    private List<AnnotationInstance> getAnnotations(DeploymentUnit depUnit, String className) {
        CompositeIndex index = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        List annotations = index.getAnnotations(DotName.createSimple((String)className));
        return annotations;
    }

    private AnnotationInstance getAnnotation(DeploymentUnit depUnit, String className) {
        List<AnnotationInstance> annotations = this.getAnnotations(depUnit, className);
        return annotations.size() == 1 ? annotations.get(0) : null;
    }

    private boolean allowAdditionalModuleDependencies(DeploymentUnit depUnit) {
        boolean isWar = DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)depUnit);
        boolean isEjb = EjbDeploymentMarker.isEjbDeployment((DeploymentUnit)depUnit);
        boolean isCDI = WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)depUnit);
        boolean isJPA = JPADeploymentMarker.isJPADeployment((DeploymentUnit)depUnit);
        return isWar || isEjb || isCDI || isJPA;
    }

    public void undeploy(DeploymentUnit depUnit) {
        depUnit.removeAttachment(OSGiConstants.DEPLOYMENT_KEY);
    }
}

