/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;

public class OSGiFrameworkPropertyRemove
extends AbstractRemoveStepHandler {
    static final OSGiFrameworkPropertyRemove INSTANCE = new OSGiFrameworkPropertyRemove();

    private OSGiFrameworkPropertyRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        final String propName = operation.get("address").asObject().get("property").asString();
        final SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState == null) {
            context.setRollbackOnly();
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            return;
        }
        final String oldVal = subsystemState.setProperty(propName, null);
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                subsystemState.setProperty(propName, oldVal);
            }
        });
    }
}

