/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.ServiceTracker;

public class InitialDeploymentTracker
extends ServiceTracker<Object> {
    private static final ServiceName INITIAL_DEPLOYMENTS = OSGiConstants.SERVICE_BASE_NAME.append(new String[]{"initial", "deployments"});
    public static final ServiceName INITIAL_DEPLOYMENTS_COMPLETE = IntegrationServices.BootstrapPhase.serviceName((ServiceName)INITIAL_DEPLOYMENTS, (IntegrationServices.BootstrapPhase)IntegrationServices.BootstrapPhase.COMPLETE);
    private final Set<ServiceName> expectedServices = Collections.synchronizedSet(new HashSet());
    private final Set<Deployment> deployments = Collections.synchronizedSet(new HashSet());
    private final ServiceTarget serviceTarget;
    private final Set<String> deploymentNames;
    private ServiceTarget listenerTarget;

    public InitialDeploymentTracker(OperationContext context) {
        super(InitialDeploymentTracker.class.getSimpleName());
        this.serviceTarget = context.getServiceTarget();
        this.deploymentNames = this.getDeploymentNames(context);
        for (String name : this.deploymentNames) {
            this.expectedServices.add(org.jboss.as.server.deployment.Services.deploymentUnitName((String)name, (Phase)Phase.DEPENDENCIES));
        }
        if (!this.expectedServices.isEmpty()) {
            ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
            this.listenerTarget = serviceRegistry.getService(Services.JBOSS_SERVER_CONTROLLER).getServiceContainer();
            this.listenerTarget.addListener((ServiceListener)this);
        }
        this.checkAndComplete();
    }

    protected boolean trackService(ServiceController<? extends Object> controller) {
        ServiceName serviceName = controller.getName();
        return this.expectedServices.contains(serviceName);
    }

    protected void serviceListenerAdded(ServiceController<? extends Object> controller) {
        ServiceName serviceName = controller.getName();
        OSGiLogger.LOGGER.tracef("Track service: %s", serviceName);
        this.expectedServices.remove(serviceName);
    }

    protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
        return this.expectedServices.isEmpty();
    }

    protected void serviceStarted(ServiceController<? extends Object> controller) {
        ServiceName serviceName = controller.getName();
        OSGiLogger.LOGGER.tracef("ServiceStarted: %s", serviceName);
        ServiceContainer serviceContainer = controller.getServiceContainer();
        ServiceController depUnitController = serviceContainer.getRequiredService(serviceName.getParent());
        DeploymentUnit depUnit = (DeploymentUnit)depUnitController.getValue();
        Deployment deployment = (Deployment)depUnit.getAttachment(OSGiConstants.DEPLOYMENT_KEY);
        if (deployment != null) {
            this.deployments.add(deployment);
        }
    }

    protected void serviceStartFailed(ServiceController<? extends Object> controller) {
        ServiceName serviceName = controller.getName();
        OSGiLogger.LOGGER.warnf("ServiceStartFailed: %s", serviceName);
    }

    protected void complete() {
        if (this.listenerTarget != null) {
            this.listenerTarget.removeListener((ServiceListener)this);
        }
        this.addPhaseCompleteService(this.serviceTarget, INITIAL_DEPLOYMENTS_COMPLETE);
    }

    public boolean hasDeploymentName(String depname) {
        return this.deploymentNames.contains(depname);
    }

    public Set<Deployment> getDeployments() {
        return Collections.unmodifiableSet(this.deployments);
    }

    private Set<String> getDeploymentNames(OperationContext context) {
        HashSet<String> result = new HashSet<String>();
        ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
        ModelNode depmodel = model.get("deployment");
        if (depmodel.isDefined()) {
            List deploymentNodes = depmodel.asList();
            for (ModelNode node : deploymentNodes) {
                Property property = node.asProperty();
                ModelNode enabled = property.getValue().get("enabled");
                if (!enabled.isDefined() || !enabled.asBoolean()) continue;
                result.add(property.getValue().get("runtime-name").asString());
            }
            OSGiLogger.LOGGER.debugf("Expecting initial deployments: %s", result);
        }
        return result;
    }

    private ServiceController<Object> addPhaseCompleteService(ServiceTarget serviceTarget, ServiceName serviceName) {
        return serviceTarget.addService(serviceName, (Service)new ValueService((Value)new ImmediateValue(new Object()))).install();
    }
}

