/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.SpecDescriptorPropertyReplacement;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.merge.web.jboss.JBossWebMetaDataMerger;
import org.jboss.metadata.parser.servlet.WebMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class WebBundleFragmentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        XBundleRevision hostRev = (XBundleRevision)depUnit.getAttachment(OSGiConstants.BUNDLE_REVISION_KEY);
        WarMetaData warMetaData = (WarMetaData)depUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null || hostRev == null) {
            return;
        }
        XBundle fragment = null;
        BundleWiring wiring = hostRev.getWiring();
        Iterator i$ = wiring.getProvidedWires("osgi.wiring.host").iterator();
        if (i$.hasNext()) {
            BundleWire wire = (BundleWire)i$.next();
            fragment = (XBundle)wire.getRequirer().getBundle();
        }
        if (fragment == null) {
            return;
        }
        URL entry = fragment.getEntry("WEB-INF/web.xml");
        if (entry == null) {
            return;
        }
        WebMetaData fragmentMetaData = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            MetaDataElementParser.DTDInfo dtdInfo = new MetaDataElementParser.DTDInfo();
            inputFactory.setXMLResolver((XMLResolver)dtdInfo);
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(entry.openStream());
            fragmentMetaData = WebMetaDataParser.parse((XMLStreamReader)xmlReader, (MetaDataElementParser.DTDInfo)dtdInfo, (PropertyReplacer)SpecDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)depUnit));
        }
        catch (XMLStreamException ex) {
            OSGiLogger.LOGGER.debugf((Throwable)ex, "Cannot parse web.xml in fragment: %s", (Object)fragment);
        }
        catch (IOException ex) {
            OSGiLogger.LOGGER.debugf((Throwable)ex, "Cannot parse web.xml in fragment: %s", (Object)fragment);
        }
        if (fragmentMetaData != null) {
            warMetaData.setWebMetaData(fragmentMetaData);
            JBossWebMetaData mergedMetaData = new JBossWebMetaData();
            JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
            JBossWebMetaDataMerger.merge((JBossWebMetaData)mergedMetaData, (JBossWebMetaData)metaData, (WebMetaData)fragmentMetaData);
            warMetaData.setMergedJBossWebMetaData(mergedMetaData);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

