/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.buildagent.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import org.jboss.pnc.buildagent.api.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
public class TaskStatusUpdateEvent
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TaskStatusUpdateEvent.class);
    private final String taskId;
    private final Status newStatus;
    private final String outputChecksum;
    private final String message;
    private final Object context;
    @Deprecated
    private final Status oldStatus;

    @Deprecated
    public TaskStatusUpdateEvent(String taskId, Status oldStatus, Status newStatus, String context, String outputChecksum) {
        this.taskId = taskId;
        this.oldStatus = oldStatus;
        this.newStatus = newStatus;
        this.context = context;
        this.outputChecksum = outputChecksum;
        this.message = "";
    }

    @Deprecated
    public TaskStatusUpdateEvent(String taskId, Status oldStatus, Status newStatus, String context) {
        this.taskId = taskId;
        this.oldStatus = oldStatus;
        this.newStatus = newStatus;
        this.context = context;
        this.outputChecksum = "";
        this.message = "";
    }

    private TaskStatusUpdateEvent(Builder builder) {
        this.taskId = builder.taskId;
        this.newStatus = builder.newStatus;
        this.outputChecksum = builder.outputChecksum;
        this.message = builder.message;
        this.oldStatus = builder.oldStatus;
        this.context = builder.context;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(TaskStatusUpdateEvent copy) {
        Builder builder = new Builder();
        builder.taskId = copy.getTaskId();
        builder.newStatus = copy.getNewStatus();
        builder.outputChecksum = copy.getOutputChecksum();
        builder.message = copy.getMessage();
        builder.oldStatus = copy.getOldStatus();
        builder.context = copy.getContext();
        return builder;
    }

    public String getTaskId() {
        return this.taskId;
    }

    @Deprecated
    public Status getOldStatus() {
        return this.oldStatus;
    }

    public Status getNewStatus() {
        return this.newStatus;
    }

    public Object getContext() {
        return this.context;
    }

    public String getOutputChecksum() {
        return this.outputChecksum;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            log.error("Cannot serialize object.", (Throwable)e);
            return null;
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String taskId;
        private Status newStatus;
        private String outputChecksum;
        private String message;
        private Status oldStatus;
        private Object context;

        private Builder() {
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder newStatus(Status newStatus) {
            this.newStatus = newStatus;
            return this;
        }

        public Builder outputChecksum(String outputChecksum) {
            this.outputChecksum = outputChecksum;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder context(Object context) {
            this.context = context;
            return this;
        }

        @Deprecated
        public Builder oldStatus(Status oldStatus) {
            this.oldStatus = oldStatus;
            return this;
        }

        public TaskStatusUpdateEvent build() {
            return new TaskStatusUpdateEvent(this);
        }
    }
}

