/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.causeway.dto.push;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import lombok.NonNull;
import org.jboss.pnc.api.causeway.dto.push.Build;
import org.jboss.pnc.api.dto.Request;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildImportRequest {
    @NonNull
    private final Request callback;
    @NonNull
    private final Build build;
    private final boolean reimport;

    @JsonCreator
    public BuildImportRequest(@JsonProperty(value="callback") Request callback, @JsonProperty(value="build") Build build, @JsonProperty(value="reimport") Boolean reimport) {
        this.callback = Objects.requireNonNull(callback, "Callback must be specified.");
        this.build = Objects.requireNonNull(build, "Build information must be specified.");
        this.reimport = reimport != null && reimport != false;
    }

    @NonNull
    public Request getCallback() {
        return this.callback;
    }

    @NonNull
    public Build getBuild() {
        return this.build;
    }

    public boolean isReimport() {
        return this.reimport;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildImportRequest)) {
            return false;
        }
        BuildImportRequest other = (BuildImportRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReimport() != other.isReimport()) {
            return false;
        }
        Request this$callback = this.getCallback();
        Request other$callback = other.getCallback();
        if (this$callback == null ? other$callback != null : !((Object)this$callback).equals(other$callback)) {
            return false;
        }
        Build this$build = this.getBuild();
        Build other$build = other.getBuild();
        return !(this$build == null ? other$build != null : !((Object)this$build).equals(other$build));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildImportRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReimport() ? 79 : 97);
        Request $callback = this.getCallback();
        result = result * 59 + ($callback == null ? 43 : ((Object)$callback).hashCode());
        Build $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        return result;
    }

    public String toString() {
        return "BuildImportRequest(callback=" + this.getCallback() + ", build=" + this.getBuild() + ", reimport=" + this.isReimport() + ")";
    }
}

