/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.causeway.dto.push;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=LogfileBuilder.class)
public class Logfile {
    @NonNull
    private final String filename;
    @NonNull
    private final String deployPath;
    private final int size;
    @NonNull
    private final String md5;

    Logfile(@NonNull String filename, @NonNull String deployPath, int size, @NonNull String md5) {
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        if (deployPath == null) {
            throw new NullPointerException("deployPath is marked non-null but is null");
        }
        if (md5 == null) {
            throw new NullPointerException("md5 is marked non-null but is null");
        }
        this.filename = filename;
        this.deployPath = deployPath;
        this.size = size;
        this.md5 = md5;
    }

    public static LogfileBuilder builder() {
        return new LogfileBuilder();
    }

    @NonNull
    public String getFilename() {
        return this.filename;
    }

    @NonNull
    public String getDeployPath() {
        return this.deployPath;
    }

    public int getSize() {
        return this.size;
    }

    @NonNull
    public String getMd5() {
        return this.md5;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Logfile)) {
            return false;
        }
        Logfile other = (Logfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$deployPath = this.getDeployPath();
        String other$deployPath = other.getDeployPath();
        if (this$deployPath == null ? other$deployPath != null : !this$deployPath.equals(other$deployPath)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        return !(this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Logfile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSize();
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $deployPath = this.getDeployPath();
        result = result * 59 + ($deployPath == null ? 43 : $deployPath.hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        return result;
    }

    public String toString() {
        return "Logfile(filename=" + this.getFilename() + ", deployPath=" + this.getDeployPath() + ", size=" + this.getSize() + ", md5=" + this.getMd5() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class LogfileBuilder {
        private String filename;
        private String deployPath;
        private int size;
        private String md5;

        LogfileBuilder() {
        }

        public LogfileBuilder filename(@NonNull String filename) {
            if (filename == null) {
                throw new NullPointerException("filename is marked non-null but is null");
            }
            this.filename = filename;
            return this;
        }

        public LogfileBuilder deployPath(@NonNull String deployPath) {
            if (deployPath == null) {
                throw new NullPointerException("deployPath is marked non-null but is null");
            }
            this.deployPath = deployPath;
            return this;
        }

        public LogfileBuilder size(int size) {
            this.size = size;
            return this;
        }

        public LogfileBuilder md5(@NonNull String md5) {
            if (md5 == null) {
                throw new NullPointerException("md5 is marked non-null but is null");
            }
            this.md5 = md5;
            return this;
        }

        public Logfile build() {
            return new Logfile(this.filename, this.deployPath, this.size, this.md5);
        }

        public String toString() {
            return "Logfile.LogfileBuilder(filename=" + this.filename + ", deployPath=" + this.deployPath + ", size=" + this.size + ", md5=" + this.md5 + ")";
        }
    }
}

