/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms;

import org.jboss.portal.cms.model.Content;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.cms.model.Folder;
import org.jboss.portal.search.impl.jcr.JCRQuery;

import java.util.List;
import java.util.Locale;

/**
 * Factory to create commands for the cms service.
 *
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 8332 $
 */
public interface CommandFactory
{
   Command createNewFileCommand(File sFile, Content content);

   Command createUpdateFileCommand(File sFile, Content content, boolean makeLive);

   Command createCopyCommand(String sFromPath, String sToPath);

   Command createMoveCommand(String sFromPath, String sToPath);

   Command createRenameCommand(String sPath, String sNewName);

   Command createDeleteCommand(String sPath);

   Command createFileSaveCommand(File file);

   Command createFileGetCommand(String sFilePath, Locale locale);

   Command createFileGetCommand(String sFilePath, String sVersionNumber, Locale locale);

   Command createFileUpdateCommand(File file);

   Command createFolderSaveCommand(Folder folder);

   Command createFolderGetCommand(String sFolderPath);

   Command createFolderUpdateCommand(Folder folder);

   Command createContentGetVersionsCommand(String sFilePath);

   Command createFolderGetListCommand(String sFolderPath);

   Command createContentCreateNewVersionCommand(Content content, boolean bMakeLive);

   Command createContentCreateNewVersionCommand(List contents, boolean bMakeLive);

   Command createStoreArchiveCommand(String sRootPath, byte[] archiveBytes, String sLanguage);
   
   Command createAsyncStoreArchiveCommand(String sRootPath, byte[] archiveBytes, String sLanguage);

   Command createItemExistsCommand(String sPath);

   Command createContentSaveCommand(File file);

   Command createContentGetCommand(String sFilePath, String sVersionNumber, Locale locale);

   Command createFileGetListCommand(String sFilePath);

   Command createGetArchiveCommand(String sRootPath, String sLanguage);   

   Command createSearchCommand(JCRQuery query);

   Command createMakeLiveVersionCommand(String filePath, String language, String version);
   
   Command createDownloadArchiveCommand(String filePath);   
}
