/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.hibernate;

import java.io.Serializable;

/** @author <a href="mailto:roy@jboss.org">Roy Russo</a> */
public class RepositoryEntry implements Serializable
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 8428814876834347136L;

   private Integer key;
   private String path;
   private String name;
   private java.sql.Blob data;
   private long lastmod;
   private long length;

   public RepositoryEntry()
   {
   }

   public RepositoryEntry(String path, String name, java.sql.Blob data, long lastmod, long length)
   {
      this.key = null;
      this.path = path;
      this.name = name;
      this.data = data;
      this.lastmod = lastmod;
      this.length = length;
   }

   public Integer getKey()
   {
      return key;
   }

   public void setKey(Integer key)
   {
      this.key = key;
   }

   public String getPath()
   {
      return path;
   }

   public void setPath(String path)
   {
      this.path = path;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public java.sql.Blob getData()
   {
      return data;
   }

   public void setData(java.sql.Blob data)
   {
      this.data = data;
   }

   public long getLastmod()
   {
      return lastmod;
   }

   public void setLastmod(long lastmod)
   {
      this.lastmod = lastmod;
   }

   public long getLength()
   {
      return length;
   }

   public void setLength(long length)
   {
      this.length = length;
   }
}
