/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.hibernate.state;

import java.io.Serializable;

/** @author <a href="mailto:roy@jboss.org">Roy Russo</a> */
public class WSPBinVal implements Serializable
{
   /** The serialVersionUID */
   private static final long serialVersionUID = -6052991380871814524L;

   private Integer key;
   private String id;
   private java.sql.Blob data;

   public WSPBinVal()
   {
   }

   public WSPBinVal(String id, java.sql.Blob data)
   {
      this.key = null;
      this.id = id;
      this.data = data;
   }

   public Integer getKey()
   {
      return key;
   }

   public void setKey(Integer key)
   {
      this.key = key;
   }

   public String getId()
   {
      return id;
   }

   public void setId(String id)
   {
      this.id = id;
   }

   public java.sql.Blob getData()
   {
      return data;
   }

   public void setData(java.sql.Blob data)
   {
      this.data = data;
   }
}
