/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.cms.model.Content;
import org.jboss.portal.cms.util.FileUtil;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;


/**
 * CMS Version implementation.
 *
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 * @author <a href="mailto:christophe.lombart@sword-technologies.com">Christophe Lombart</a>
 */
public class ContentImpl extends CMSObjectImpl implements Content, Serializable
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 4439612949586405113L;

   protected final static Log log = LogFactory.getLog(ContentImpl.class);

   protected byte[] bytes;

   protected String encoding;

   protected boolean isLive;

   protected String versionNumber;

   protected Locale locale;

   protected String mimeType;

   protected long size;

   protected boolean isWaitingForPublishApproval = false;
   protected String approvalProcessId = null;

   public String getTitle()
   {
      return title;
   }

   public void setTitle(String title)
   {
      this.title = title;
   }

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String description)
   {
      this.description = description;
   }

   public Locale getLocale()
   {
      return locale;
   }

   public void setLocale(Locale locale)
   {
      this.locale = locale;
   }

   public String getVersionNumber()
   {
      return versionNumber;
   }

   public void setVersionNumber(String versionNumber)
   {
      this.versionNumber = versionNumber;
   }

   /** @return Returns the content. */
   public InputStream getStream()
   {
      return new ByteArrayInputStream(this.getBytes());
   }

   /** @return Returns the content. */
   public byte[] getBytes()
   {
	  //Code Around for issues with Oracle JDBC Driver. An empty byte array translates into a NULL Blob which blows up since
	  //The column is NON-NULLABLE. All other tested database drivers mysql5, postgresql8, hsqldb etc are just fine since they translate into an 
	  //empty BLOB object
	  if(this.bytes == null || this.bytes.length==0)
	  {
		  this.bytes = " ".getBytes();
	  }
	  
      return this.bytes;
   }

   public String getContentAsString()
   {
      if (encoding != null)
      {
         try
         {
            return new String(this.getBytes(), encoding);
         }
         catch (UnsupportedEncodingException e)
         {
         }
      }
      return new String(this.getBytes());
   }

   /** @param stream The content to set. */
   public void setStream(InputStream stream)
   {
      this.bytes = FileUtil.getBytes(stream);
   }

   /** @param bytes The content to set. */
   public void setBytes(byte[] bytes)
   {
      this.bytes = bytes;
   }

   /** @return Returns the encoding. */
   public String getEncoding()
   {
      return encoding;
   }

   /** @param encoding The encoding to set. */
   public void setEncoding(String encoding)
   {
      this.encoding = encoding;
   }

   public boolean isLive()
   {
      return isLive;
   }

   public void setLive(boolean live)
   {
      isLive = live;
   }

   public long getSize()
   {
      return this.size;
   }

   public String getMimeType()
   {
      return mimeType;
   }

   public void setMimeType(String mimeType)
   {
      this.mimeType = mimeType;
   }

   public void setSize(long size)
   {
      this.size = size;
   }

   /**
    *
    */
   public boolean isWaitingForPublishApproval()
   {
      return this.isWaitingForPublishApproval;
   }

   /** @param isWaitingForPublishApproval  */
   public void setWaitingForPublishApproval(boolean isWaitingForPublishApproval)
   {
      this.isWaitingForPublishApproval = isWaitingForPublishApproval;
   }

   /** @return the approvalProcessId */
   public String getApprovalProcessId()
   {
      return approvalProcessId;
   }

   /** @param approvalProcessId the approvalProcessId to set */
   public void setApprovalProcessId(String approvalProcessId)
   {
      this.approvalProcessId = approvalProcessId;
   }
}


