/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.command;

import org.jboss.portal.cms.impl.FileImpl;
import org.jboss.portal.cms.impl.FolderImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.cms.model.Folder;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import java.util.ArrayList;
import java.util.List;

/**
 * Retrieves the folder for the given path and sets the child folders and child files in the Folder obj.
 *
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 * @author <a href="mailto:sohil.shah@jboss.com">Sohil Shah</a>
 */
public class FolderGetListCommand extends JCRCommand
{
   /** The serialVersionUID */
   private static final long serialVersionUID = -754630384075659266L;
   String sFolderPath;

   public FolderGetListCommand(String sFolderPath)
   {
      this.sFolderPath = sFolderPath;
   }

   public Object execute()
   {
      try
      {
         Folder folder = new FolderImpl();

         Node folderNode = (Node)context.getSession().getItem(sFolderPath);
         folder.setName(folderNode.getName());
         if (!"/".equals(sFolderPath))
         {
            folder.setDescription(folderNode.getProperty("portalcms:description").getString());
            folder.setLastModified(folderNode.getProperty("portalcms:lastmodified").getDate().getTime());
         }
         folder.setBasePath(sFolderPath);

         // get child folders
         List folders = new ArrayList();
         List files = new ArrayList();
         NodeIterator ni = folderNode.getNodes();
         while (ni.hasNext())
         {
            try
            {
               Node node = ni.nextNode();
               NodeType nt = node.getPrimaryNodeType();
               String ntName = nt.getName();
               if (ntName.equals("portalcms:folder"))
               {
                  JCRCommand folderList = (JCRCommand)context.getCommandFactory().createFolderGetCommand(node.getPath());
                  Folder childFolder = (Folder)context.execute(folderList);
                  folders.add(childFolder);
               }
               else if (ntName.equals("portalcms:file"))
               {
                  //JCRCommand fileList = (JCRCommand) context.getCommandFactory().createFileGetMetaDataCommand(node.getPath(), null);
                  //File childFile = (File) context.execute(fileList);
                  File childFile = this.getFileMetaData(node.getPath(), context);
                  files.add(childFile);
               }
            }
            catch (Exception e)
            {
               // if this occurs, typically it is due to accessDenied. don't
               // worry about this resource
            }
         }
         folder.setFolders(folders);
         folder.setFiles(files);
         return folder;

      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return null;
   }

   /**
    * This method just gets the properties associated with the file and not its content. This enhances the performance.
    *
    * @param msPath
    * @param JCRCommandContext
    * @return
    */
   public File getFileMetaData(String msPath, JCRCommandContext context) throws Exception
   {
      File file = null;

      //build File
      file = new FileImpl();
      Session session = context.getSession();

      Node fileNode = (Node)session.getItem(msPath);
      fileNode = (Node)session.getItem(msPath);
      file.setCreationDate(fileNode.getProperty("jcr:created").getDate().getTime());
      file.setLastModified(fileNode.getProperty("jcr:lastModified").getDate().getTime());
      file.setBasePath(msPath);
      file.setName(fileNode.getName());

      return file;
   }
}
