/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.util;

import javax.jcr.Node;
import javax.jcr.RepositoryException;


/** @author <a href="mailto:theute@jboss.org">Thomas Heute</a> */
public class NodeTypeUtil
{

   public static final String FOLDER_TYPE = "portalcms:folder";

   public static final String FILE_TYPE = "portalcms:file";

   public static final String CONTENT_TYPE = "portalcms:content";

   public static boolean isFolder(Node node)
   {
      try
      {
         return node.getPrimaryNodeType().getName().equals(FOLDER_TYPE);
      }
      catch (RepositoryException e)
      {
         return false;
      }
   }

   public static boolean isFile(Node node)
   {
      try
      {
         return node.getPrimaryNodeType().getName().equals(FILE_TYPE);
      }
      catch (RepositoryException e)
      {
         return false;
      }
   }

   public static boolean isContent(Node node)
   {
      try
      {
         return node.getPrimaryNodeType().getName().equals(CONTENT_TYPE);
      }
      catch (RepositoryException e)
      {
         return false;
      }
   }
}
