/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.util;

import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Date;

import javax.jcr.Node;

import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.StringValue;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.model.Folder;
import org.jboss.portal.cms.util.NodeUtil;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.impl.FolderImpl;

/**
 * @author <a href="mailto:sshah@redhat.com">Sohil Shah</a>
 *
 */
public class ResourceUtil
{
   /** @param parentPath  */
   public static void createParentHierarchy(JCRCommandContext context, String parentPath) throws CMSException
   {
      try
      {
         StringTokenizer tokenizer = new StringTokenizer(parentPath, "/");
   
         StringBuffer buffer = new StringBuffer("/");
         while (tokenizer.hasMoreTokens())
         {
            buffer.append(tokenizer.nextToken());
            String cour = buffer.toString();
   
            JCRCommand nodeExists = (JCRCommand)context.getCommandFactory().createItemExistsCommand(cour);
            Boolean bExists = (Boolean)context.execute(nodeExists);
            if (!bExists.booleanValue())
            {
               ResourceUtil.createFolder(context, cour);
            }
            else
            {
               //Make Sure this resource is not a file. You don't want to create a Folder inside a File
               Node node = (Node)context.getSession().getItem(cour);
               if(NodeTypeUtil.isFile(node))
               {
                  throw new CMSException("Invalid Path: "+ parentPath + " : Trying to create a Folder inside a File");
               }
            }
   
            if (tokenizer.hasMoreTokens())
            {
               buffer.append("/");
            }
         }
      }
      catch(Exception e)
      {
         throw new CMSException(e);
      }
   }

   /**
    * @param folderPath
    * @throws CMSException
    */
   private static void createFolder(JCRCommandContext context, String folderPath) throws CMSException
   {
      try
      {
         Folder folder = new FolderImpl();
         folder.setName(folderPath);
         folder.setDescription(folderPath);
         folder.setTitle(folderPath);
         folder.setLastModified(new Date());
         folder.setBasePath(folderPath);
   
         String parentPath = NodeUtil.getParentPath(folder.getBasePath());
         String nodeName = NodeUtil.getNodeName(folder.getBasePath());
   
         Node parentNode = (Node)context.getSession().getItem(parentPath);
         Node folderNode = parentNode.addNode(nodeName, "portalcms:folder");
         folderNode.setProperty("portalcms:description", new StringValue(folder.getDescription()));
   
         Calendar calendar = Calendar.getInstance();
         calendar.setTime(folder.getLastModified());
         DateValue dv = new DateValue(calendar);
         parentNode.setProperty("portalcms:lastmodified", dv);
         folderNode.setProperty("portalcms:lastmodified", dv);
         parentNode.save();
      }
      catch(Exception e)
      {
         throw new CMSException(e);
      }
   }
}
