/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.util;

import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;

/**
 * Helper class for JCR Repositories.
 *
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 */
public class RepositoryUtil
{

   private RepositoryUtil()
   {
   }

   /**
    * Handles authentication for the specified repository.
    *
    * @param repository
    * @param user
    * @param password
    * @return session
    */
   public static Session login(Repository repository, String user, String password) throws Exception
   {
      return repository.login(new SimpleCredentials(user, password.toCharArray()), null);
   }

   public static void safeLogout(Session session)
   {
      if (session != null)
      {
         session.logout();
      }
   }
}