/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms;

import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.xml.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

/**
 * @author <a href="mailto:palber@novell.com">Polina Alber</a> Date: Apr 30, 2005; Time: 2:10:44 AM
 * @since JBoss portal 2.0 Class org.jboss.portal.setup.impl.dl.cmsloader.CMSMimeMappings
 */
public class CMSMimeMappings
{

   /** Definition of default mime type mappings to file extension. */
   private static final String MAPPINGS_FILE = "org/jboss/portal/cms/mime-mappings.xml";

   /** . */
   private final HashMap mappings = new HashMap();

   public CMSMimeMappings()
   {
      InputStream is = null;
      try
      {
         is = Thread.currentThread().getContextClassLoader().getResourceAsStream(MAPPINGS_FILE);
         Document dmt = XMLTools.getDocumentBuilderFactory().newDocumentBuilder().parse(is);
         Element docElmt = dmt.getDocumentElement();
         List mappingsList = XMLTools.getChildren(docElmt, "mime-mapping");
         for (int i = 0; i < mappingsList.size(); i++)
         {
            Element mapping = (Element)mappingsList.get(i);
            String extension = XMLTools.asString(XMLTools.getUniqueChild(mapping, "extension", true));
            String mimeType = XMLTools.asString(XMLTools.getUniqueChild(mapping, "mime-type", true));
            mappings.put(extension, mimeType);
         }
      }
      catch (Exception e)
      {
         throw new Error("Cannot load mime mapping file", e);
      }
      finally
      {
         IOTools.safeClose(is);
      }
   }

   public String getMimeType(String fileExtension)
   {
      return (String)mappings.get(fileExtension);
   }
}
