/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.command;

import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.StringValue;
import org.jboss.portal.cms.CMSMimeMappings;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.model.File;

import javax.jcr.Node;
import java.util.Calendar;

/**
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 * @author <a href="mailto:theute@jboss.org">Thomas Heute</a>
 */
public class ContentCreateCommand extends FileBasedJCRCommand
{
   /** The serialVersionUID */
   private static final long serialVersionUID = -2843288770902185840L;

   public ContentCreateCommand(File file)
   {
      super(file);
   }

   public Object execute()
   {
      try
      {
         String basePath = mFile.getBasePath();
         JCRCommandContext context = (JCRCommandContext)getContext();
         Node fileNode = (Node)context.getSession().getItem(basePath);

         Node contentNode = fileNode.addNode(mFile.getContent().getLocale().getLanguage(), "portalcms:content");
         contentNode.setProperty("jcr:encoding", "UTF-8");
         contentNode.setProperty("jcr:data", new BinaryValue(mFile.getContent().getBytes()));
         contentNode.setProperty("jcr:lastModified", new DateValue(Calendar.getInstance()));
         contentNode.setProperty("portalcms:description", new StringValue(mFile.getContent().getDescription()));
         contentNode.setProperty("portalcms:title", new StringValue(mFile.getContent().getTitle()));
         contentNode.setProperty("portalcms:language", new StringValue(mFile.getContent().getLocale().getLanguage()));
         contentNode.setProperty("portalcms:size", new StringValue(String
               .valueOf(mFile.getContent().getBytes().length)));


         if (mFile.getContent().getMimeType() != null)
         {
            contentNode.setProperty("jcr:mimeType", mFile.getContent().getMimeType());
         }
         else
         {
            String fileExt = basePath.substring(basePath.lastIndexOf(".") + 1, basePath.length());
            CMSMimeMappings mapper = new CMSMimeMappings();
            if (mapper.getMimeType(fileExt) != null)
            {
               contentNode.setProperty("jcr:mimeType", mapper.getMimeType(fileExt));
            }
            else
            {
               contentNode.setProperty("jcr:mimeType", "application/octet-stream");
            }
         }
         contentNode.addMixin("mix:versionable");

         // Save this for other sessions.
         context.getSession().save();
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return null;
   }
}
