/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.command;

import org.apache.log4j.Logger;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.StringValue;

import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.util.ResourceUtil;
import org.jboss.portal.cms.model.Folder;
import org.jboss.portal.cms.util.NodeUtil;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import java.util.Calendar;

/**
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 * @author <a href="mailto:theute@jboss.org">Thomas Heute</a>
 */
public class FolderCreateCommand extends FolderBasedJCRCommand
{
   /** The serialVersionUID */
   private static final long serialVersionUID = -3007711915681479942L;
   private static Logger log = Logger.getLogger(FolderCreateCommand.class);

   public FolderCreateCommand(Folder folder)
   {
      super(folder);
   }

   public Object execute()
   {
      try
      {
         String basePath = mFolder.getBasePath();
         String parentPath = NodeUtil.getParentPath(basePath);
         String nodeName = NodeUtil.getNodeName(basePath);
         
         //Make sure the Path hierarchy is complete
         ResourceUtil.createParentHierarchy(context, parentPath);

         Node parentNode = (Node)context.getSession().getItem(parentPath);
         Node folderNode = parentNode.addNode(nodeName, "portalcms:folder");
         folderNode.setProperty("portalcms:description", new StringValue(mFolder.getDescription()));

         Calendar calendar = Calendar.getInstance();
         calendar.setTime(mFolder.getLastModified());
         DateValue dv = new DateValue(calendar);
         parentNode.setProperty("portalcms:lastmodified", dv);
         folderNode.setProperty("portalcms:lastmodified", dv);
         parentNode.save();
      }
      catch (ItemExistsException iee)
      {
         // fail silently. TODO: throw, so user knows folder exists.
      }
      catch (Exception e)
      {
         log.error(this, e);
         throw new CMSException(e);
      }
      return null;
   }
}
