/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.command;

import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.FileImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.search.impl.jcr.JCRQuery;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:theute@jboss.org">Thomas Heute</a>
 * @version $Revision$
 */
public class SearchCommand extends JCRCommand
{

   private static final long serialVersionUID = 2614067614144410297L;

   private JCRQuery query;

   public SearchCommand(JCRQuery query)
   {
      this.query = query;
   }


   public Object execute() throws CMSException
   {
      Session session = context.getSession();
      Workspace workspace = session.getWorkspace();
      QueryManager queryManager;
      List files = new ArrayList();
      String queryString = null;
      try
      {
         queryManager = workspace.getQueryManager();

         queryString = query.getJcrQuery();

         if (!"".equals(queryString) && query != null)
         {
            javax.jcr.query.Query jcrQuery = queryManager.createQuery(queryString, javax.jcr.query.Query.XPATH);
            QueryResult queryResult = jcrQuery.execute();
            NodeIterator nodeIterator = queryResult.getNodes();

            while (nodeIterator.hasNext())
            {
               Node node;
               node = nodeIterator.nextNode().getParent();
               File file = new FileImpl();
               file.setBasePath(node.getPath());
               file.setCreationDate(node.getProperty("jcr:created").getDate().getTime());
               file.setLastModified(node.getProperty("jcr:lastModified").getDate().getTime());
               file.setName(node.getName());
               files.add(file);
            }
         }
      }
      catch (Exception e)
      {
         throw new CMSException("Cannot query the CMS with query: " + queryString, e);
      }
      return files;
   }

}
