/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.composite;

import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.impl.jcr.JCRCompositeCommand;
import org.jboss.portal.cms.impl.jcr.command.ContentCreateCommand;
import org.jboss.portal.cms.impl.jcr.command.ContentCreateNewVersionCommand;
import org.jboss.portal.cms.impl.jcr.command.FileCreateCommand;
import org.jboss.portal.cms.model.Content;
import org.jboss.portal.cms.model.File;

/**
 * @author <a href="mailto:theute@jboss.org">Thomas Heute</a>
 * @author <a href="mailto:sohil.shah@jboss.com">Sohil Shah</a> - Nov 28, 2006
 */
public class NewFileCommand extends JCRCompositeCommand
{

   /** The serialVersionUID */
   private static final long serialVersionUID = -6134173065175936408L;

   //
   private String path = null;
   private Content content = null;

   /** @return  */
   public String getPath()
   {
      return this.path;
   }

   /** @return  */
   public Content getContent()
   {
      return this.content;
   }

   public NewFileCommand(File file, Content content)
   {
      // setAttribute("file", file);
      // setAttribute("content", content);
      this.path = file.getBasePath();
      this.content = content;

      Command saveFileCMD = new FileCreateCommand(file);
      commands.add(saveFileCMD);
      Command saveContentCMD = new ContentCreateCommand(file);
      commands.add(saveContentCMD);
      Command verCMD = new ContentCreateNewVersionCommand(content, true);
      commands.add(verCMD);
   }

}