/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.model;

import java.io.InputStream;
import java.util.Locale;

/**
 * CMS content interface.
 *
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 * @version $Id: Content.java 5929 2006-12-22 20:15:42Z sohil.shah@jboss.com $
 */
public interface Content extends CMSObject, Cloneable
{
   String getMimeType();

   void setMimeType(String type);

   /** @return the */
   long getSize();

   void setSize(long size);

   /** @return Returns the content. */
   InputStream getStream();

   /** @param stream The content to set. */
   void setStream(InputStream stream);

   /** @return Returns the content. */
   byte[] getBytes();

   /** @param bytes The content to set. */
   void setBytes(byte[] bytes);

   String getVersionNumber();

   void setVersionNumber(String versionNumber);

   Locale getLocale();

   void setLocale(Locale locale);

   String getContentAsString();

   /** @return Returns the encoding. */
   String getEncoding();

   /** @param encoding The encoding to set. */
   void setEncoding(String encoding);

   boolean isLive();

   void setLive(boolean live);

   /**
    * this is used to signify that a content is waiting to be approved before being published to go live
    *
    * @return
    */
   public boolean isWaitingForPublishApproval();

   /**
    *
    *
    */
   public void setWaitingForPublishApproval(boolean isWaitingForPublishApproval);

   /** @return  */
   public String getApprovalProcessId();

   /**
    *
    *
    */
   public void setApprovalProcessId(String processId);
}

